
/* ###--------------------------------------------------------------### */
/* 									*/
/* file		: syf_beh_rmvbebus.c					*/
/* date		: Aug 24 1992						*/
/* version	: v102							*/
/* authors	: Pirouz BAZARGAN SABET					*/
/* content	: contains a specific function used to delete a		*/
/*		  behaviour data structure				*/
/*									*/
/* ###--------------------------------------------------------------### */

#include MUT_H 
#include LOG_H 
#include BEH_H 

/* ###--------------------------------------------------------------### */
/* function	: syf_beh_rmvbebus						*/
/* description	: delete a BEBUS structure and return the pointer of	*/
/*		  the next object. A warning is printed out if the	*/
/*		  object to be deleted is not empty when the mode is N	*/
/* called func.	: mbkfree						*/
/* ###--------------------------------------------------------------### */

struct syf_bebus *syf_beh_rmvbebus (listbebus, bebusname, mode)

struct syf_bebus *listbebus;	/* list of bebus containing the object	*/
char         *bebusname;	/* name of the BEBUS to be deleted	*/
char          mode;		/* recursive delete or not (Y or N)	*/

  {
  struct syf_bebus  headbus;
  struct syf_bebus *ptlastbus;
  struct syf_bebus *ptbebus;

  if (listbebus != NULL)
    {

	/* ###------------------------------------------------------### */
	/*    Search the object to be deleted				*/
	/* ###------------------------------------------------------### */

    headbus.NEXT = listbebus;
    ptbebus      = &headbus;
    while ((ptbebus != NULL) && (ptbebus->NAME != bebusname))
      {
      ptlastbus = ptbebus;
      ptbebus   = ptbebus->NEXT;
      }

    if (ptbebus != NULL)
      {

	/* ###------------------------------------------------------### */
	/*    If the object doesn't exist return the list without	*/
	/* modification.						*/
	/*    If the object has been found check the mode and, if asked	*/
	/* delete pointed objects recursively.				*/
	/* ###------------------------------------------------------### */

      if (mode == 'N')
        {
        if ((ptbebus->BIABL != NULL) || (ptbebus->BINODE != NULL))
          (void) fprintf (stderr,"BEH_warning : bebus `%s` not empty\n",
                          bebusname);
        }
      else
        {
        syf_beh_frebiabl  (ptbebus->BIABL);
        syf_beh_frebinode (ptbebus->BINODE);
        }

      ptlastbus->NEXT = ptbebus->NEXT;
      mbkfree (ptbebus);
      }

    listbebus = headbus.NEXT;
    }

  return(listbebus);
  }
