/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur de FSM                                       */
/*    Fichier :  syf_mstack.c                                                  */
/*                                                                          */
/*    (c) copyright 1993 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  C. Sarwary                            le : 08/09/1993     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/***************************************************************************/
#include <stdio.h>
#include <math.h>
#include MUT_H
#include LOG_H
#include"../beh104/beh104.h"
#include "syf_must.h"
#include "syf_beh2fsm.h"
#include "syf_auto.h"
#include "../util/util.h"
/*--------------------------------------------------------------------
equivState	:	Detecte les etats ayant les memes transitions.
------------------------------------------------------
parametres	:	.
------------------------------------------------------
return		:	.
---------------------------------------------------------------------*/
equivState()
{
int i ;

for(i = 0; i < autoSys->numberState ; i++)
	dispEquivState(i) ;
}
/*--------------------------------------------------------------------
dispEquivState	: visualise les etats ayant les memes transitions que
					l'etat passe en parametre.
------------------------------------------------------
parametres		:	label.
------------------------------------------------------
return			:	.
---------------------------------------------------------------------*/
dispEquivState(label)
int label ;
{
int i, equiv, numTrans ;
pState state ;
pTrans trans, trans2, curTrans ;

state = autoSys->state + label ;
printf("STATE : %s\n",state->name) ;
trans = state->trans ;
state++ ;
for(i = label + 1; i < autoSys->numberState ; i++)
	{
	if(state->user == (void *)0)
		{
		equiv = 1 ;
		curTrans = trans ;
		trans2 = state->trans ;
		if((numTrans = equalNumTrans(curTrans,trans)))
			{
			while(curTrans)
				{
				if(!existTrans(trans2,curTrans->abl))
					{
					equiv = 0 ;
					break ;
					}
				curTrans = curTrans->next ;
				}
			if(equiv)
				{
				printf("\t%s\n",state->name) ;
				state->user = (void *)1 ;
				}
			}
		}
	state++ ;
	}
}
/*--------------------------------------------------------------------
equalNumTrans	: Return trans number if the tow trans have the same trans
				  number, 0 else.
------------------------------------------------------
parametres		: trans1,trans2.
------------------------------------------------------
return			: num.
---------------------------------------------------------------------*/
equalNumTrans(trans1,trans2)
pTrans trans1, trans2 ;
{
pTrans t1,t2 ;
int num ;

num = 0 ;
t1 = trans1 ;
t2 = trans2 ;
while(t1)
	{
	if(!t2)
		return(0) ;
	num++ ;
	t1 = t1->next ;
	t2 = t2->next ;
	}
return(num) ;
}
/*--------------------------------------------------------------------
existTrans	: Verifie l'existance d'un abl dans la structure trans.
------------------------------------------------------
parametres		:	trans,abl.
------------------------------------------------------
return			:	.
---------------------------------------------------------------------*/
existTrans(trans,abl)
pTrans trans ;
chain_list *abl ;
{
pTrans trans2 ;

trans2 = trans ;
while(trans2)
	{
	if(trans->bdd != (pNode)-2)
		{
		if(equalExpr(trans->abl,abl))
			{
			trans->bdd = (pNode)-2 ;
			return(1) ;
			}
		}
	trans2 = trans2->next ;
	}
return(0) ;
}
