
/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur de FSM                                       */
/*    Fichier :  syf_must.c                                                  */
/*                                                                          */
/*    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  C. Sarwary                            le : 04/03/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/***************************************************************************/

#include <stdio.h>
#include <math.h>
#include MUT_H
#include LOG_H
#include "syf_auto.h"
#include "syf_must.h"
#include "../util/util.h"

/*---------------------------------------------------------------------------
mustang           : regroupe tous les fonctions du codage mustang
---------------------------------------------------------------------------
parametres        : aucun
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
mustang(AME)
int AME;
{
p_groupe  Se;
int *tabCode;
int *tabPoidEtat;
 int *affinity;
 int *we;
 int *nwS;
 int *nwO;
 int selectLabel,i;
 int numberBit;

numberBit = autoSys->numberReg;

if(!(nwS = (int *)mbkalloc((autoSys->numberState +1 )*(autoSys->numberState +1)  * sizeof(int ))))
   {
   printf("allocation impossible \n");
   exit(-1);
   }
if(!(nwO = (int *)mbkalloc((autoSys->numberState + 1)*(autoSys->numberOut) * sizeof(int ))))
   {
   printf("allocation impossible \n");
   exit(-1);
   }

 for(i = 0; i < bit[numberBit]; i++)
        (autoSys->code + i)->code = bit[numberBit] ;
 autoSys->dc  = autoSys->code + autoSys->numberState;

mustPoids(nwS,nwO);
we = mustCalcul(nwS,nwO);
tabCode = choixGroupe(we);
if(AME)
{
tabPoidEtat = asp_poidEtat();
affinity =PoidsFutur();
for(i =0; i<AME; i++)
{
  Se= stateGeneration();
  while(Se)
  {
  selectLabel = codeModification(we,tabPoidEtat,affinity,tabCode,Se);
  Se = delFromgroup(Se, selectLabel);
  }
 printf("%dieme iteration\n",i+1);
}
}
/*#ifndef ARCHI_PC*/
free(we);
free(nwS);
free(nwO);
/*#endif*/
}


/*---------------------------------------------------------------------------
 mustPoids    :  remplit les matrices de poids des etats .
-----------------------------------------------------------------
 parametres   : aucun .
-----------------------------------------------------------------
 return       : rien
---------------------------------------------------------------------------*/
 void mustPoids(nwS,nwO)
 int *nwS;
 int *nwO; 
 {
 int i, j;
 int DIMS;
 pLocOut locOut;
 pTrans trans;
 pState state;

for(i = 0; i < (autoSys->numberState + 1)*(autoSys->numberState + 1); i++)
	nwS[i] = 0 ;
for(i = 0; i < (autoSys->numberState + 1)*(autoSys->numberOut); i++)
	nwO[i] = 0 ;
 
  state = autoSys->state;
  DIMS = autoSys->numberState;

  for(j = 0; j < autoSys->numberState; j++)
  {
    trans = state->trans;
    while (trans)
    {
	if(trans->sPlabel != -1)
	  {
      (nwS[j * DIMS + trans->sPlabel])++ ;
	  }
    trans = trans->next;
    }
      locOut = state->locOut;
        while(locOut)
         {
  	 (nwO[(locOut->label)*DIMS + j])++ ;
         locOut = locOut->next;
        }
    state++;
  }
 }
/*---------------------------------------------------------------------------
 mustCalcul   : calcul le poids effectif de chaque couple d'etats .
---------------------------------------------------------------------
 parametres   : aucun .
--------------------------------------------------------------------
 return       : rien .
---------------------------------------------------------------------------*/
 int *mustCalcul(nwS,nwO)
 int *nwS;
 int *nwO; 
 {
 int i,k,l;
 int DIMS;
 int *we;

 we = (int *)mbkalloc((autoSys->numberState + 1)* autoSys->numberState * sizeof(int )) ;

 for(i = 0; i < (autoSys->numberState + 1)*(autoSys->numberState); i++)
	we[i] = 1 ; 

  DIMS = autoSys->numberState;
  for(k = 0; k < autoSys->numberState ; k++)
  {
    for(l = 0; l < autoSys->numberState ; l++)
    {
      for(i = 0; i < autoSys->numberState; i++)
      {
	if (k!=l) we[k * DIMS +l] += nwS[i*DIMS +k]*nwS[i*DIMS +l];
      }
	we[k*DIMS +l] *= autoSys->numberReg;
      for(i = 0 ; i < autoSys->numberOut; i++)
     if (k!=l) 	we[k*DIMS +l] += nwO[i*DIMS +k]*nwO[i*DIMS +l];
    }
    we[k*DIMS +l] = 0 ;
  }
 return(we);
 }

/*---------------------------------------------------------------------------
stateGeneration   : genere le groupe d'etats initiale pour le codage 
---------------------------------------------------------------------
parametres        : aucun
--------------------------------------------------------------------
return            : le groupe initiale des etats a coder .
---------------------------------------------------------------------------*/
p_groupe stateGeneration()
{
 int i;
 p_groupe gm_aux ;
 p_groupe gm = NULL;

 for(i = autoSys->numberState -1 ; i >= 0; i--)
 {
  if(!(gm_aux = (p_groupe)mbkalloc(sizeof(struct E_groupe))))
  {
  printf("mustang : allocation impossible \n");
  exit(-1);
  }
  gm_aux->label = i ;
  gm_aux->next = gm;
  gm=gm_aux;
 }
return(gm);
}

/*---------------------------------------------------------------------------
displayGroup      : affiche l'ensembles des etats qui non pas etait choisis 
---------------------------------------------------------------------------
parametres        : le groupe des etats non codes   
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
displayGroup(gg)
p_groupe gg;
{
printf("---------groupe -------\n");
while(gg)
 { 
  printf("%d-- \n",gg->label);
  gg = gg->next;
 }
}


/*---------------------------------------------------------------------------
choixGroupe       : genere le groupe des etats qui vont etre coder a la 
                    prochaine iteration . 
---------------------------------------------------------------------------
parametres        : aucun   
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
int *choixGroupe(we)
int *we;
{
p_groupe gg;
pCode code;
pCode dc;
int  *Voisin;
int *tabCode;
int  max = 0;
int  Val,i;
int  selectLabel;
int  courantLabel;
int numberBit;
int nextCode = 0;
int DIMS;

DIMS = autoSys->numberState;
numberBit = autoSys->numberReg;

if(!(Voisin = (int *)mbkalloc(numberBit * sizeof(int))))
   {
   printf("allocation impossible \n");
   exit(-1);
   }
if(!(tabCode = (int*)mbkalloc(bit[numberBit] * sizeof(int))))
  {
   printf("allocation impossible \n");
   exit(-1);
  }
  for  (i = 0; i < numberBit; i++)
  Voisin[i] = autoSys->numberState;
  for  (i = 0; i < bit[numberBit]; i++)
    tabCode[i] = bit[numberBit];
  code = autoSys->code;
  gg = stateGeneration();
/*-----------------------------------------------------------------*/
/* selection du prochain element a etre coder .                    */
/* cette operation est repetee jusqu'au codage de tous les etats . */
/*-----------------------------------------------------------------*/
  while(gg)
  {
  int i,j ;
  p_groupe gg_aux;
  p_groupe gg_auxY;
  gg_aux = gg;

  selectLabel = gg->label;
  while(gg_aux)
  {
  i = 0;
  courantLabel = gg_aux->label;
  gg_auxY = gg ;

   while(gg_auxY)
   {
   int label = gg_auxY->label;
   if (we[courantLabel*DIMS +label] > we[courantLabel*DIMS +Voisin[i]])
       {
	i++;
	if (i == numberBit)
	{
	 for(i = 0; i < (numberBit - 1); i++)
	   Voisin[i] = Voisin[i + 1];
	   Voisin[i] = gg_auxY->label;
	}
       }
   else
      {
       if (i > 0)
	{
	 for(j = 0; j < i - 1; j++)
	   Voisin[j] = Voisin[j + 1];
	   Voisin[j] = gg_auxY->label;
	}
       }
       gg_auxY = gg_auxY->next;
    }
  Val = 0;
  for (i = 0; i < numberBit; i++)
   Val += we[courantLabel* DIMS +Voisin[i]];
  if (Val > max)
  {
    selectLabel = courantLabel;
    max =Val;
  }
 gg_aux = gg_aux->next;
 }
 mustCodage(selectLabel, Voisin, tabCode, &nextCode);
 gg = delFromgroup(gg, selectLabel);
 }
   dc = autoSys->dc;
 courantLabel = autoSys->numberState;
 for(i = 0; i < bit[numberBit]; i++)
 {
 if(tabCode[i] == bit[numberBit]) 
   {
   tabCode[i] = courantLabel++;
   dc->code = i;
   dc++;
   }
 }
return(tabCode);
}

/*---------------------------------------------------------------------------
delFromgroup      : enleve un element du groupe  
---------------------------------------------------------------------------
parametres        : le groupe , l'element a enlever .   
--------------------------------------------------------------------------
return            : le groupe modifier .
---------------------------------------------------------------------------*/
p_groupe delFromgroup(gg, selectLabel)
p_groupe gg;
int selectLabel;
{
 p_groupe ggAux;

 ggAux =gg;
 
if(ggAux->label == selectLabel) 
   gg = gg->next;

 while(ggAux->next)
 {
  int label = ggAux->next->label;
   if(label == selectLabel) 
   {
      ggAux->next = (ggAux->next)->next ; 
      return(gg);
   }
  ggAux =ggAux->next;
 }
return(gg);
}
/*---------------------------------------------------------------------------
addTogroup        : ajoute un element au groupe  
---------------------------------------------------------------------------
parametres        : le groupe , l'element a ajouter .   
--------------------------------------------------------------------------
return            : le groupe modifier .
---------------------------------------------------------------------------*/
p_groupe addTogroup(gg, selectLabel)
p_groupe gg;
int selectLabel;
{
 p_groupe gmAux;

 gmAux =gg;

 while(gmAux)
 {
  int label = gmAux->label;
   if(label == selectLabel) 
      return(gg);
  gmAux = gmAux->next;
 }

  if(!(gmAux = (p_groupe)mbkalloc(sizeof(struct E_groupe))))
  {
  printf("mustang : allocation impossible \n");
  exit(-1);
  }

  gmAux->label = selectLabel ;
  gmAux->next = gg;
  gg = gmAux;
  return(gg);
}

/*---------------------------------------------------------------------------
mustCodage        : attribue un code a l'element selectionner ainsi qu'a
                    tous ces voisins.  
---------------------------------------------------------------------------
parametres        : l'etat selectionner , ces voisins, la table des codes 
                    et le prochain code a etre attribuer .   
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
 p_groupe mustCodage(selectLabel, Voisin, tabCode, nextCode)
 int selectLabel, *Voisin;
 int *tabCode;
 int *nextCode;
 {
 int numberBit;
 pCode code;
 p_groupe Sa;
 int i,val;

 numberBit = autoSys->numberReg;
 code = autoSys->code;
 if (((code + selectLabel)->code) == bit[numberBit])
	{
	  (code + selectLabel)->code = *nextCode;
          tabCode[(*nextCode)] =  selectLabel;
        }
	  for(i = numberBit -1; i >= 0; i--)
	  {
	   if ((Voisin[i] != autoSys->numberState) &&
	      ((code + Voisin[i])->code == bit[numberBit]))
             {
              val = voisin(tabCode, (code + selectLabel)->code);
	      (code + Voisin[i])->code = val;
               tabCode[val] =  Voisin[i];
             }

	 }
      for(i = *nextCode ; i < bit[numberBit]; i++)
      if (tabCode[i] == bit[numberBit])
      {
      *nextCode = i;
      i = bit[numberBit];
      }

 return(Sa);
 }


/*---------------------------------------------------------------------------
voisin            : return le code le plus proche a CODE parmis les codes
                    non encore attribuer 
---------------------------------------------------------------------------
parametres        : la table des codes, le code . 
--------------------------------------------------------------------------
return            : le code le plus proche non encore affecter .
---------------------------------------------------------------------------*/
 int voisin(tabCode, code)
 int *tabCode, code;
 {
  int numberBit = autoSys->numberReg;
  int newCode ;
  int dist ;
  int k;

   newCode = bit[numberBit];
   dist = numberBit;
   for (k = 0; k < bit[numberBit]; k++)
   {
   if (tabCode[k] == bit[numberBit])
   {
    if (dist > distHaming(k, code,numberBit))
       {
       dist = distHaming(k, code,numberBit);
       newCode = k;
       }
   }
  }
   return(newCode);
  }

/*---------------------------------------------------------------------------
displayWhiteState : visualise la matrice de poids pour state .
---------------------------------------------------------------------------
parametres        : aucun
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
void displayWhiteState(we,nwS)
int *we;
int *nwS;
{
int i, j, DIMS;

printf("\n\n**************** MTRICE DES POIDS STATEs ****************\n\n") ;
DIMS = autoSys->numberState;
for(i = 0; i < autoSys->numberState; i++)
	for(j = 0; j < autoSys->numberState; j++)
        {
		printf("nwS[%d,%d] = %d\n",i,j,nwS[i* DIMS +j]) ;
		printf("we[%d,%d] = %d\n",i,j,we[i* DIMS +j]) ;
        }
printf("\n\n**************** FIN DE VISUALISATION ****************\n\n") ;
}
/*---------------------------------------------------------------------------
displayWhiteOut   : visualise la matrice de poids pour out .
---------------------------------------------------------------------------
parametres        : aucun
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
void displayWhiteOut(nwO)
int *nwO;
{
int i, j ,DIMS;

DIMS = autoSys->numberState;
printf("\n\n**************** MTRICE DES POIDS OUT ****************\n\n") ;
for(i = 0; i < autoSys->numberOut; i++)
	for(j = 0; j < autoSys->numberState; j++)
		printf("nwS[%d,%d] = %d\n",i,j,nwO[i*DIMS +j]) ;
printf("\n\n**************** FIN DE VISUALISATION ****************\n\n") ;
}
/*---------------------------------------------------------------------------
mustAmelioration   : ameliore le codage par mustang d'une facon aleatoire.
---------------------------------------------------------------------------
parametres        : aucun
--------------------------------------------------------------------------
return            : rien .
---------------------------------------------------------------------------*/
mustAmelioration()
{
}

