/****************************************************************************/
/*                                                                          */
/*                      Chaine de CAO & VLSI   Alliance                     */
/*                                                                          */
/*    Produit :  Synthetiseur de FSM                                       */
/*    Fichier :  syf_init.c                                                  */
/*                                                                          */
/*    (c) copyright 1992 Laboratoire MASI equipe CAO & VLSI                 */
/*    Tous droits reserves                                                  */
/*    Support : e-mail cao-vlsi@masi.ibp.fr                                 */
/*                                                                          */
/*    Auteur(s) :  C. Sarwary                            le : 04/03/1992     */
/*                                                                          */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*    Modifie par :                                     le : ../../....     */
/*                                                                          */
/***************************************************************************/
#include <stdio.h>
#include <math.h>
#include MUT_H
#include LOG_H
#include"../beh104/beh104.h"
#include "syf_must.h"
#include "syf_beh2fsm.h"
#include "syf_auto.h"
#include "../util/util.h"
/*--------------------------------------------------------------------
giveComBit	:	Detecte si le rang_eme bit du code des returnState de la 
				structure de stack est le meme.
------------------------------------------------------
parametres	:	rang, le rang dans le code .
------------------------------------------------------
return		:	-1	si bit different .
				valeur de bit commun, sinon.
---------------------------------------------------------------------*/
int giveComBit(rang)
int rang ;
{
pStack stack ;
int b, b1, stateLab ;

stateLab = -1 ;
stack = autoSys->stack ;
while(stack)
	{
	if(stack->ctrl == PUSH)
		{
		stateLab = stack->returnStatelabel ;
		b = ((autoSys->code+stateLab)->code)&bit[rang] ;
		break ;
		}
	stack = stack->next ;
	}

stack = stack->next ;
while(stack)
	{
	if(stack->ctrl == PUSH)
		{
		stateLab = stack->returnStatelabel ;
		b1 = ((autoSys->code+stateLab)->code)&bit[rang] ;
		if(b != b1)
			return(-1) ;
		}
	stack = stack->next ;
	}
return(b) ;
}
/*--------------------------------------------------------------------
rempStackFixCode	:	Remplit le champ stackFixCode, et stackCodeMask de
						autoSys.
------------------------------------------------------
parametres	:	rien.
------------------------------------------------------
return		:	rien.
---------------------------------------------------------------------*/
void rempStackFixCode()
{
pStack stack ;
int b, i, stateLab ;

autoSys->stackCodeMask = 0 ;
stack = autoSys->stack ;
if(stack->next != NULL)
	for(i = 0; i < autoSys->numberReg; i++)
		{
		b = giveComBit(i) ;
		if(b != -1)
			{
			autoSys->stackFixCode += b ;
			autoSys->stackNumBit-- ;
			}
		else
			autoSys->stackCodeMask += bit[i] ;
		}
}
/*--------------------------------------------------------------------
displayStack	:	Visualise la structure stack. de
------------------------------------------------------
parametres	:	rien.
------------------------------------------------------
return		:	rien.
---------------------------------------------------------------------*/
void displayStack()
{
pStack stack ;
int b, i, stateLab ;

stack = autoSys->stack ;
while(stack)
	{
	printf("\tcurStat: %s\n",(autoSys->state+stack->curentStatelabel)->name);
	if(stack->ctrl == NOP || stack->ctrl == POP)
		printf("\tretStat: *\n");
	else
	printf("\tretStat: %s\n",(autoSys->state+stack->returnStatelabel)->name);
	switch(stack->ctrl)
		{
		case PUSH :
			printf("\tctrl : PUSH\n") ;
			break ;
		case POP :
			printf("\tctrl : POP\n") ;
			break ;
		case NOP :
			printf("\tctrl : NOP\n") ;
			break ;
		default :
			printf("SYF , ERREUR : unknown ctrl \n") ;
			exit(-1);
		}
	printf("\tcondition: ");
	displayExpr(stack->abl) ;
	printf("**************************\n") ;
	stack = stack->next ;
	}
}
/*--------------------------------------------------------------------
displayMask	:	Visualise le Mask, fixCode, et stackNumBit
------------------------------------------------------
parametres	:	rien.
------------------------------------------------------
return		:	rien.
---------------------------------------------------------------------*/
void displayMask()
{
printf("*********** DISPLAY MASK STACK ************\n") ;
printf("mask : %d\n",autoSys->stackCodeMask) ;
printf("fixCode : %d\n",autoSys->stackFixCode) ;
printf("stackNumBit : %d\n",autoSys->stackNumBit) ;
printf("*********** FIN DISPLAY MASK STACK ************\n") ;
}
