/* addaccu.c                                                        */

#include <genlib.h>

/* addaccu.c is to become the ACCU executable program. So we must   */
/* define a main procedure main()                                   */
/*                                                                  */

main()
{

/* When executed, the addaccu program opens the netlist view        */
/* "addaccu". Operations performed after opening "accu" are         */
/* taken into account.                                              */
/*                                                                  */

  DEF_LOFIG("addaccu");

/* The description of the addaccu netlist begins with the           */
/* instanciation of input/output terminals                          */
/*                                                                  */

/* We start with the input terminals.                               */

  LOCON("a0",'I',"a0");
  LOCON("a1",'I',"a1");
  LOCON("a2",'I',"a2");
  LOCON("a3",'I',"a3");
  LOCON("b0",'I',"b0");
  LOCON("b1",'I',"b1");
  LOCON("b2",'I',"b2");
  LOCON("b3",'I',"b3");
  LOCON("sel",'I',"sel");
  LOCON("ck",'I',"ck");
  LOCON("vdd",'B',"vdd");
  LOCON("vss",'B',"vss");

/* Then, the output terminals.                                  */
/*                                                              */

  LOCON("is0",'O',"is0");
  LOCON("is1",'O',"is1");
  LOCON("is2",'O',"is2");
  LOCON("is3",'O',"is3");

  LOINS("n1_y","inv0","s0","is0","vdd","vss",0) ;
  LOINS("n1_y","inv1","s1","is1","vdd","vss",0) ;
  LOINS("n1_y","inv2","s2","is2","vdd","vss",0) ;
  LOINS("n1_y","inv3","s3","is3","vdd","vss",0) ;

/* bit 0 */

  LOINS("xr2_y","xr0","mux0","b0","s0","vdd","vss",0);
  LOINS("a2_y", "an0","mux0","b0","carry0","vdd","vss",0) ;

/* bit 1 */

  LOINS("xr2_y","xr1","mux1","b1","int1","vdd","vss",0);
  LOINS("xr2_y","xr2","int1","carry0","s1","vdd","vss",0);
  LOINS("a2_y", "an1","mux1","b1","int2","vdd","vss",0) ;
  LOINS("a2_y", "an2","mux1","carry0","int3","vdd","vss",0) ;
  LOINS("a2_y", "an3","b1","carry0","int4","vdd","vss",0) ;
  LOINS("o3_y", "an4","int2","int3","int4","carry1","vdd","vss",0) ;

/* bit 2 */

  LOINS("xr2_y","xr3","mux2","b2","int5","vdd","vss",0);
  LOINS("xr2_y","xr4","int5","carry1","s2","vdd","vss",0);
  LOINS("a2_y", "an5","mux2","b2","int6","vdd","vss",0) ;
  LOINS("a2_y", "an6","mux2","carry1","int7","vdd","vss",0) ;
  LOINS("a2_y", "an7","b2","carry1","int8","vdd","vss",0) ;
  LOINS("o3_y", "an8","int6","int7","int8","carry2","vdd","vss",0) ;

/* bit 3 */

  LOINS("xr2_y","xr5","mux3","b3","int9","vdd","vss",0);
  LOINS("xr2_y","xr6","int9","carry2","s3","vdd","vss",0);
/*  LOINS("a2_y", "an9","mux3","b[3]","int10","vdd","vss",0) ; */
/*  LOINS("a2_y", "an10","mux3","carry2","int11","vdd","vss",0) ; */
/*  LOINS("a2_y", "an11","b[3]","carry2","int12","vdd","vss",0) ; */
/*  LOINS("a3_y", "an12","int10","int11","int12","carry3","vdd","vss",0) ; */

/* mux 2 to 1 */
 
  LOINS("n1_y", "n10","sel","nsel","vdd","vss",0) ;
  LOINS("mx2_y", "mux0","a0","nsel","regout0","sel","mux0", "vdd","vss",0) ;
  LOINS("mx2_y", "mux1","a1","nsel","regout1","sel","mux1", "vdd","vss",0) ;
  LOINS("mx2_y", "mux2","a2","nsel","regout2","sel","mux2", "vdd","vss",0) ;
  LOINS("mx2_y", "mux3","a3","nsel","regout3","sel","mux3", "vdd","vss",0) ;

/* accu */

  LOINS("ms_y", "l0","s0","ck","regout0","vdd","vss",0) ;
  LOINS("ms_y", "l1","s1","ck","regout1","vdd","vss",0) ;
  LOINS("ms_y", "l2","s2","ck","regout2","vdd","vss",0) ;
  LOINS("ms_y", "l3","s3","ck","regout3","vdd","vss",0) ;
   
  SAVE_LOFIG();
}
