 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: lspectrum.c
 >>>>
 >>>>      Program Name: spectrum
 >>>>
 >>>> Date Last Updated: Wed Oct  2 17:10:52 1991 
 >>>>
 >>>>          Routines: lspectrum - the library call for spectrum
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "xvinclude.h"


/* -library_includes */
#include "spectrum.h"
/* -library_includes_end */


/****************************************************************
*
* Routine Name: lspectrum - library call for spectrum
*
* Purpose:
*
* Input:
* Output:
*
* Written By: Danielle Argiro
****************************************************************/


/* -library_def */
int run_master(argc, argv, program, imagefile, legendfile)
int     argc;
char    *argv[];
char    *program;
char    *imagefile, *legendfile;
/* -library_def_end */

/* -library_code */
{
        char *form_filestring, *form_pathname;
        Arg  arg[MaxArgs];

        /*
         * initialize the display & the forms - 
         * NOTE: assuming a global 'Display *display'
         */
        display = xvf_initialize(ac, av, program);
        if (display == NULL)
        {
             fprintf(stderr, "Could not open connection to server");
             exit(0);
        }

        /*
         * Substitute below the correct filename and directory path
         * of the User Interface Description file to be used
         */
        form_filestring = xvf_strcpy("spectrum.form");
        form_pathname   = xvf_strcpy("$CLASSIFY/repos/spectrum");
        form_filestring = vfullpath(form_filestring, form_pathname, NULL);

        /*
         *  perform various initializations 
         */
        spc_init();

        /*
         *  read input image (if provided)
         */
        (void) get_new_image(imagefile);

        if (spc_image != NULL)
        {
           if (!(init_spectrum()))
           {
              fprintf(stderr, "Spectrum:\n");
              fprintf(stderr, "couldn't perform initializations.\n");
              return(false);
           }
        }

        /*
         *  read legend image (if provided)
         */
        if (legendfile != NULL)
        {
            if (spc_image != NULL)
            {
               if (!(read_legend_file(legendfile)))
               {
                   fprintf(stderr, "Spectrum:\n");
                   fprintf(stderr, "WARNING: Unable to read input legend file.\n");
               }
            }
            else
            {
                fprintf(stderr, "Spectrum:\n");
                fprintf(stderr, "WARNING: Illegal to input legend file \n");
                fprintf(stderr, "without also providing the image to which it corresponds.\n");

            }
        }
        else 
            register_image_classes();

        /*
         * Create the forms 
         */
        if (!(form = xvf_create_form(form_filestring, av, ac, SIMPLE, NULL,
                                     -1, -1)))
           exit(0);

        /*
         * Initialize the auto-generated information structure
         */
        _xvf_init_master(form,  &master_info);
        spc_workspace = master_info.image_workspace;

        legend_workspace = master_info.legend_subform->legend->legend_workspace;
        zoom_workspace = master_info.zoom_subform->zoom->zoom_workspace;

        /*
         * create & initialize workspace
         */
        if (spc_image != NULL)
        {
           if (!(init_workspace()))
           {
              fprintf(stderr, "Spectrum:\n");
              fprintf(stderr, "couldn't create workspace.\n");
              return(false);
           }
        }
        else
        {
           XtSetArg(arg[0], XtNforeground, 
                    BlackPixel(display, DefaultScreen(display)));
           XtSetValues(spc_workspace,arg,1);
           XFlush(display);
        }
        /*
         * update image colormap according to legend (if one)
         */
        if (spc_legend_list != NULL)
            update_xcolors_from_legend();

        /*
         *  create various displays
         */
        create_legend_display(legend_workspace);
        create_class_display(master_info.class_subform->class->class_workspace);
        create_plot_display(master_info.scatter_plot->scatter->plot_workspace);
        create_zoom_display(zoom_workspace);

        /*
         * Map the forms
         */
        xvf_change_active(form, true);



        do
        {
             /*
              * run the forms
              */
             form = xvf_run_form();
             if (form == NULL) break;

             /*
              * get information from the master
              */
             _xvf_get_master(form, &master_info);

             /*
              * action came from the 'files_subform' subform
              */
             if (master_info.files_subform_selected)
             {
                  run_files_subform(form, master_info.files_subform);
             }

             /*
              * action came from the 'legend_subform' subform
              */
             if (master_info.disp_subform_selected)
             {
                  run_disp_subform(form, master_info.disp_subform);
             }

             /*
              * action came from the 'zoom_subform' subform
              */
             if (master_info.zoom_subform_selected)
             {
                  run_zoom_subform(form, master_info.zoom_subform);
             }

             /*
              * action came from the 'legend_subform' subform
              */
             if (master_info.legend_subform_selected)
             {
                  run_legend_subform(form, master_info.legend_subform);
             }

             /*
              * action came from the 'zoom_subform' subform
              */
             if (master_info.zoom_subform_selected)
             {
                  run_zoom_subform(form, master_info.zoom_subform);
             }

             /*
              * action came from the 'scatter_plot' subform
              */
             if (master_info.scatter_plot_selected)
             {
                  run_scatter_plot(form, master_info.scatter_plot);
             }

        xvf_clear_selections(form->db, form->line_num);
        } while (!master_info.quit);    /* end user interface loop */

        return(True);
}
/* -library_code_end */
