 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "spectrum.h"

/********************************************************
*
*  Routine Name:  run_files_subform
*
*       Purpose:  drives the subform 'files_subform'
*
*         Input:  form - pointer to the form tree 
*		  files_subform_info  - information structure for 
*					subform 'files_subform'
*        Output:  action of the application program
*
*     Called By:  run_master()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_files_subform(form, files_subform_info)

xvf_form *form;
master_files_subform *files_subform_info;
{

	_xvf_get_files_subform(form, files_subform_info);

	/*
	 * action came from the 'files' pane
	 */
	if (files_subform_info->files_selected)
	    run_files(form, files_subform_info->files);


}   /* end run_files_subform */





/********************************************************
*
*  Routine Name:  run_files
*
*       Purpose:  drives the pane 'files'
*
*         Input:  form - pointer to the form tree 
*		  files_info  - information structure for pane 'files'
*        Output:  action of the application program
*
*     Called By:  run_files_subform()
*
*   Automatically Generated By:  conductor -i spectrum.form -l 3 -b
*
********************************************************/


run_files(form, files_info)

xvf_form *form;
files_subform_files *files_info;
{
	char temp[MaxLength];
	int  create_displays = false;
	char *label = "Enter Output Filenames";
	char **answers, **prompts;

	_xvf_get_files(form, files_info);

	/*
	 * user clicked on 'live' input file selection 'in_image'
	 */
	if (files_info->in_image_selected)
	{
	   if (spc_image == NULL) create_displays = true;

	   if (!(input_new_image(files_info->in_image)))
	      return;

	   if (create_displays)
	   {
	       create_class_display(class_workspace);
	       create_legend_display(legend_workspace);
	       create_zoom_display(zoom_workspace);
	       create_plot_display(master_info.scatter_plot->scatter->plot_workspace);
	   }
	   xvd_set_colormap(class_workspace, xvdisplay->colormap);
	   xvd_set_colormap(legend_workspace, xvdisplay->colormap);
	}

  	/*
         * protect against any other action if an image 
	 * has not been input as of yet
	 */
	else if (spc_image == NULL)
	{
	     xvf_error_wait("Please input a VIFF image before attempting any other operation.", "Spectrum", NULL);
	     return;
	}

	/*
	 * user clicked on 'live' output file selection 'out_image'
	 */
	else if (files_info->out_image_selected)
	{
	     if (write_data(files_info->out_image))
	     {
		sprintf(temp, "Image output to file %s", 
			files_info->out_image);
		xvf_error_wait(temp, "Spectrum", NULL);
	     }   
	}

	/*
	 * user clicked on 'live' output file selection 'in_legend'
	 */
	else if (files_info->in_legend_selected)
	{
	     if (spc_legend_list != NULL)  
	     {
		 if (!(xvf_warn_wait("WARNING:  inputting a new legend file will cause all current class categories to be over-written.  Are you SURE you want to replace all current class categories with those specified in the new legend?", "Spectrum", "Yes", "No"))) return;
	         if ((xvf_warn_wait("Save current image & legend?", "Spectrum", 
				"Yes", "No")))
	         {
		     prompts = (char **) calloc(1, 2*sizeof(char *));
		     answers = (char **) calloc(1, 2*sizeof(char *));
		     prompts[0] = xvf_strcpy("Output Image: ");
		     prompts[1] = xvf_strcpy("Output Legend:");
		     answers[0] = answers[1] = NULL;
	             (void) xvf_query_wait(label, prompts, NULL, 
					   answers,  2, 55);
		     if (strcmp(answers[0], "")!=0)
		     {
		        if (write_data(answers[0]))
		        {
		           sprintf(temp, "Image output to file %s", answers[0]);
		           xvf_error_wait(temp, "Spectrum", NULL);
		        }
		     }
		     if (strcmp(answers[1], "")!=0)
		     {
                        if (write_legend_file(answers[1]))
		        {
		           sprintf(temp, "Legend output to file %s", answers[1]);
		           xvf_error_wait(temp, "Spectrum", NULL);
		        }
		     }
	         }
	         delete_legend();
	     }
	     if (!(read_legend_file(files_info->in_legend)))
		return;
	     create_entry_sets();
	     update_xcolors_from_legend();
	     
	}

	/*
	 * user clicked on 'live' output file selection 'out_legend'
	 */
	else if (files_info->out_legend_selected)
	{
	     if (write_legend_file(files_info->out_legend))
	     {
		sprintf(temp, "Legend output to file %s", 
			files_info->out_legend);
		xvf_error_wait(temp, "Spectrum", NULL);
	     }   
	}

	/*
	 * user clicked on 'live' output file selection 'out_image_cmap'
	 */
	else if (files_info->out_image_cmap_selected)
	{
	     output_image_and_cmap(files_info->out_image_cmap);

	}

	/*
	 * user clicked on 'live' output file selection 'out_cmap'
	 */
	else if (files_info->out_cmap_selected)
	{
	    output_cmap_only(files_info->out_cmap);
	}
}
