/**********************************************************************/
/* scene.h                                                            */
/*                                                                    */
/* Simple set of structures to support drawing of quad/triangular     */
/* polygons                                                           */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef SCENE_H
#define SCENE_H

#define RGB_SCALE 255.0              /* For scaling to RGB colour    */
#define RGB_ROUND 0.5

#define MAX_SPECTRA_SAMPLES 3        /* Spectra                      */
#define MAX_PATCH_VTX 4              /* Max # of vert per poly       */
#define PATCH 0
#define TRIANGLE 1
#define PATCH_ID "patch"
#define TRI_ID "triangle"

#define VERY_LARGE    (1e+5)
#define ENLARGE_WORLD (0.6)         /* Amount to enlarge world BV by */

typedef struct {
  int id;                           /* Polygon id                    */
  char *name;                       /* Polygon name                  */
  int class;                        /* PATCH or TRIANGLE             */
  double B[MAX_SPECTRA_SAMPLES];    /* Polygon colour                */
  double                            /* Colour at vertices            */
    vtx_B[MAX_PATCH_VTX][MAX_SPECTRA_SAMPLES];
  Vector vertex[MAX_PATCH_VTX];     /* Polygon vertices              */
  Vector normal[MAX_PATCH_VTX];     /* Polygon normals               */
  int numVert;                      /* Numnber of vertices in patch  */
} SPolygon;

typedef struct SMeshType {          /* Set of polygons               */
  SPolygon *polys;                  /* polygons in set               */
  int num_polys;                    /* Number of polygons in set     */
} SMesh;

typedef struct {                    /* Scene options                 */
  int log;                          /* log execution                 */
  int totpoly;                      /* Total number of polygons in scene */
  BoundingBoxType worldbox;         /* Bounding box around the scene */
  double worldSize;                 /* Worlds radius                 */
} SLogType;

#endif /* SCENE_H */
