/**********************************************************************/
/* walkv.c :                                                          */
/*                                                                    */
/* Global variables for program                                       */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <fmclient.h>
#include <math.h>
#include <gl/gl.h>
#include <gl/device.h>
#define IRIS4D 1
#include "geo.h"
#include "walk.h"
#include "vcr.h"

SystemAttrib System = { /* Default options for system.      */
  1.34,                 /* Default x/y aspect ratio         */
  1024,                 /* Default x screeen size           */
  LARGEZ,               /* Default z max                    */
  FALSE, FALSE, FALSE,  /* Do not use prefered window size  */
                        /* nor position                     */
  TRUE, TRUE, FALSE,    /* Use double, zbuffer, no Abuffer  */
  FALSE,                /* No panel                         */
  FALSE,                /* No graphics initialized          */
  FALSE,                /* Not using VCR                    */
  0,                    /* No VCR mode                      */
  FALSE,                /* No gamma                         */
  FALSE                 /* Using full screen                */
  };
  
OptionType Option = {   /* Default options (user)           */
  NODEBUG,              /* Not debugging                    */
  STILL,                /* Not moving                       */
  NOLOG,                /* Not logging session              */
  1.0,                  /* No zoomfactor                    */
  GOURAUD,              /* Gouraud shade polygons           */
  SHADE_QUAD,           /* Default shade quadralaterals     */
  FALSE,                /* No BW shading                    */
  ".",                  /* default directory of input scene */
  TRUE,                 /* default draw xyz axis            */
  1.0                   /* default no RGB scaling           */
  };

/**********************************************************************/
/* Movement structures */
/**********************************************************************/
Matrix objmat = {       /* Current object transformation matrix */
  {1.0, 0.0, 0.0, 0.0},
  {0.0, 1.0, 0.0, 0.0},
  {0.0, 0.0, 1.0, 0.0},
  {0.0, 0.0, 0.0, 1.0},
};

Matrix viewmat = {       /* Current viewer transformation matrix */
  {1.0, 0.0, 0.0, 0.0},
  {0.0, 1.0, 0.0, 0.0},
  {0.0, 0.0, 1.0, 0.0},
  {0.0, 0.0, 0.0, 1.0},
};

Matrix Identity = {     /* Identity matrix */
    {1.0, 0.0, 0.0, 0.0},
    {0.0, 1.0, 0.0, 0.0},
    {0.0, 0.0, 1.0, 0.0},
    {0.0, 0.0, 0.0, 1.0},
};

int moves_logged = 0;   /* Current number of movements logged */
FILE *movefile;         /* File of Movements (camera movement)        */
char *movefilename;     /* Filename of "movement" file                */

Movement *Autoview;     /* Set of movements to run automatically      */
Movement *Mtail;        /* Current last movement                      */
AbsMovement Viewer;     /* Absolute movement of the viewer            */
RelMovement view;       /* Relative movement tracking info            */
MouseMovement Mouse;    /* Mouse movement tracking info               */

/**********************************************************************/
/* Input scene stuff                                                  */
/**********************************************************************/
FILE *scenefile;        /* File containing input scene/environment    */
/* Object *scene; */    /* Input scene                                */

/**********************************************************************/
/* A-buffer structures (not used) */
/**********************************************************************/
int KernelId = -1;
char **Kernels = 0;
int NumKernels = 0;
char *KernelFile = 0;

/**********************************************************************/
/* Window structures                                                  */
/**********************************************************************/
char *ProgName = "walk";              /* program name                 */

char *WindowName = "R-Walk";   /* Main window label                   */
long WindWid;                  /* Main window id                      */  
long WindXorigin, WindYorigin; /* Main window origin (x,y)            */
long WindXsize, WindYsize;     /* Main window size (x,y)              */
  
long PanelWid;                 /* Panel window id                     */

long HelpWid;                  /* Help window id                      */
char *HelpCmd = 0;
long Menu = -1;                /* Main menu */

/**********************************************************************/
/* Font stuff for panels, menus                                       */
/**********************************************************************/
fmfonthandle FontScreen, FontScreen5, FontScreen8, FontScreen10;
fmfontinfo FontScreenInfo, FontScreen5Info, FontScreen8Info, FontScreen10Info;

/**********************************************************************/
/* Copy a relative viewer movement */
/**********************************************************************/
void CopyViewChg(oview, nview)
     RelMovement *oview, *nview;
{  
  oview->rot[0] = nview->rot[0];
  oview->rot[1] = nview->rot[1]; 
  oview->rot[2] = nview->rot[2]; 
  oview->transl[0] = nview->transl[0]; 
  oview->transl[1] = nview->transl[1]; 
  oview->transl[2] = nview->transl[2]; 
}

/**********************************************************************/
/* Copy a viewer position */
/**********************************************************************/
void CopyViewer(viewer,nviewer)
     AbsMovement *viewer, *nviewer;
     
{
  viewer->lookFrom.x = nviewer->lookFrom.x;
  viewer->lookFrom.y = nviewer->lookFrom.y ; 
  viewer->lookFrom.z = nviewer->lookFrom.z ; 
  viewer->lookAt.x =   nviewer->lookAt.x ; 
  viewer->lookAt.y =   nviewer->lookAt.y ; 
  viewer->lookAt.z =   nviewer->lookAt.z ; 
  viewer->lookUp.x =   nviewer->lookUp.x ; 
  viewer->lookUp.y =   nviewer->lookUp.y ; 
  viewer->lookUp.z =   nviewer->lookUp.z ; 
  viewer->xRes =       nviewer->xRes; 
  viewer->yRes =       nviewer->yRes;
  viewer->fovx =       nviewer->fovx; 
  viewer->fovy =       nviewer->fovy; 
  viewer->near =       nviewer->near ; 
  viewer->far =        nviewer->far ;
  viewer->bank =       nviewer->bank ; 
}
