/****************************************************************************
**
**    printpc.c                       NQ                       Werner Nickel
**
**    Copyright 1992                            Mathematics Research Section
**                                           School of Mathematical Sciences 
**                                            Australian National University
*/

#include "presentation.h"
#include "pc.h"

static	FILE	*OutFp = stdout;

void	PrintPcGen( g )
gen	g;

{	int	inverse = 0;

	if( g < 0 ) { g = -g; inverse = 1; }

	if( PcGenName[g] == (char *)0 ) fprintf( OutFp, ".%d", g );
	else                            fprintf( OutFp, "%s", PcGenName[g] );

	if( inverse ) fprintf( OutFp, "^-1" );
}

void	PrintPcWord( w )
word	w;

{	if( w->g == EOW ) {
	    fprintf( OutFp, "1" );
	    return;
	}

	if( w->g > 0 ) {
	    PrintPcGen( w->g );
	    if( w->e > 1 ) fprintf( OutFp, "^%d", w->e );
	}
	else {
	    PrintPcGen( -w->g );
	    fprintf( OutFp, "^-%d", w->e );
	}
	w++;
	    
	while( w->g != EOW ) {
	    fputc( '*', OutFp );
	    if( w->g > 0 ) {
		PrintPcGen( w->g );
		if( w->e > 1 ) fprintf( OutFp, "^%d", w->e );
	    }
	    else {
		PrintPcGen( -w->g );
		fprintf( OutFp, "^-%d", w->e );
	    }
	    w++;
	}
}


void	PrintPcPow( g, n, rhs, defining )
gen	g;
exp	n;
word	rhs;
int	defining;

{	char	*gname;

	PrintPcGen( g );
	fprintf( OutFp, "^%d", n );
	if( rhs != (word)0 && rhs->g != EOW ) {
	    fprintf( OutFp, " =%c ", defining ? ':' : ' ' );
	    PrintPcWord( rhs );
	}
}

void	PrintPcConj( h, g, rhs, defining )
gen	h, g;
word	rhs;
int	defining;

{	char	*gname;

	PrintPcGen( h );
	fprintf( OutFp, "^" );
	if( g < 0 ) {
		fprintf( OutFp, "(" );
		PrintPcGen( -g );
		fprintf( OutFp, "^-1)" );
	}
	else     PrintPcGen( g );

	fprintf( OutFp, " =%c ", defining ? ':' : ' ' );
	if( rhs != (word)0 ) PrintPcWord( rhs );
	else                 PrintPcGen( h );
}

#define	PRINTED 0x1
void	PrintPcPres() {

	char	*gname;
	gen	a, g, h;
	int	comma = 0;

	fprintf( OutFp, "< " );

	/* Print the list of generators first. */
	PrintPcGen( 1 );
	for( a = 2; a <= NrPcGens+NrCenGens; a++ ) {
	    fprintf( OutFp, ", " );
	    PrintPcGen( a );
	}

	fprintf( OutFp, " |\n    " );

	comma = 0;
	/* Now print the relations, defining relations first. */
	/* The pointers to the defining relations are marked as printed. */
	if( Definition != (def *)0 ) 
	    for( a = 1; a <= NrPcGens+NrCenGens; a++ )
		if( (h = Definition[a].h) > (gen)0 )
		    if( (g = Definition[a].g) == (gen)0 ) {
			if( comma ) fprintf( OutFp, ",\n    " );
			else        comma = 1;
			PrintPcPow( h, Exponent[h], Power[h], 1 );
			Power[h] = (word)((unsigned long)Power[h] | PRINTED);
		    }
		    else {
			if( comma ) fprintf( OutFp, ",\n    " );
			else        comma = 1;
			PrintPcConj( h, g, Conjugate[h][g], 1 );
			Conjugate[h][g] =
			    (word)((unsigned long)Conjugate[h][g] | PRINTED);
		    }

	/* Now print the power relations. */
	for( a = 1; a <= NrPcGens+NrCenGens; a++ )
	    if( Exponent[a] != 0 )
		if( !((unsigned long)Power[a] & PRINTED) ) {
		    if( comma ) fprintf( OutFp, ",\n    " );
		    else        comma = 1;
		    PrintPcPow( a, Exponent[a], Power[a], 0 );
		}
		else {
		    Power[a] = (word)((unsigned long)Power[a] & ~PRINTED);
		}

	/* Now print the conjugate relations. */
	if( Conjugate != (word **)0 )
	    for( h = 1; h <= NrPcGens+NrCenGens; h++ )
		if( Conjugate[h] != (word *)0 )
		    for( g = 1; g < h; g++ ) {
			if( !((unsigned long)Conjugate[h][g] & PRINTED) ) {
			    if( Conjugate[h][g] != (word)0 &&
				(Conjugate[h][g][0].g != h ||
				 Conjugate[h][g][0].e != 1 ||
				 Conjugate[h][g][1].g != EOW ) ) {
				if( comma ) fprintf( OutFp, ",\n    " );
				else        comma = 1;
				PrintPcConj( h, g, Conjugate[h][g], 0 );
			    }
			}
			else {
			    Conjugate[h][g] =
			     (word)((unsigned long)Conjugate[h][g] & ~PRINTED);
			}
			if( Exponent[g] != 0 ) continue;
			if( !((unsigned long)Conjugate[h][-g] & PRINTED) ) {
			    if( Conjugate[h][-g] != (word)0 &&
				(Conjugate[h][-g][0].g != h ||
				 Conjugate[h][-g][0].e != 1 ||
				 Conjugate[h][-g][1].g != EOW ) ) {
				if( comma ) fprintf( OutFp, ",\n    " );
				else        comma = 1;
				PrintPcConj( h, -g, Conjugate[h][-g], 0 );
			    }
			}
			else {
			    Conjugate[h][-g] =
			     (word)((unsigned long)Conjugate[h][-g] & ~PRINTED);
			}
		    }

	fprintf( OutFp, "\n>\n" );
}

void	InitPrintPc( fp )
FILE	*fp;

{	OutFp = fp;
}
