/* Animates values between lower and upper in an image */
/* Input data file should contain starting image configuration, and */
/* updates in "point value" format. Strings on a new line of the form */
/* "Time = xxx" are interpreted as specifying the simulation time, */
/* which is subsequently displayed in the animation window */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <string.h>
#include <math.h>
#include <time.h>

#define TitleHeight 20
int screenWidth, screenHeight;

Display *mydisplay;
Window mywindow;
GC mygc;

XEvent myevent;
KeySym mykey;

XSizeHints myhint;
char filename[30];

int rows,columns,Factor,Skip;
float LowerThreshold,UpperThreshold;
FILE *fp;
int Hexagonal=0;
unsigned long myforeground, mybackground;
int image[300][300];
int line =0;
int pointsDisplayed;
char display[100];

int CountPoints() 
/* counts foreground points in image */
{
  XImage* theImage;
  int x,y;
  int count=0;

  theImage = XGetImage(mydisplay,mywindow,
		       myhint.x,myhint.y,
		       screenWidth, screenHeight,
		       0x01, XYPixmap);
  for(y = TitleHeight; y<screenHeight;y++)
    for(x = 0; x<screenWidth;x++)
      count += (XGetPixel(theImage,x,y) == myforeground);
  fprintf(stdout,"Number of points counted from XGetImage = %d\n", 
	    count/Factor/Factor);
  return count/Factor/Factor;
}

void determineSize()
{
  char c;
  char line[1000];

  fp=fopen(filename, "r");
  if (fp==NULL) {
    fprintf(stderr,"%s: file does not exist\n",filename);
    exit(2);
  }
  if (rows == 0) { /* explicit information about image size */
    while( fscanf(fp,"%s\n",line) != EOF) 
      if (strncmp(line,"GridSize->(",strlen("GridSize->(")) == 0){
	sscanf(line,"GridSize->(%d,%d)",&columns,&rows);
	return;
      }
    fprintf(stderr,"%s: Information about grid size not found, assuming equal number of columns and rows\n",filename);
  }
  /* implicit information about number of columns */
  fclose(fp);
  fp=fopen(filename, "r");
  while((c = getc(fp)) != ':' && c!= EOF);
  if (c==EOF) {
    fprintf(stderr,"%s: no CPL image data found in file\n",filename);
    exit(3);
  }
  columns=0;
  while((c=getc(fp)) != ':' && c!= EOF) 
    if (c==' ') columns++;
  if (rows == 0) rows = columns;
  fclose(fp);
}

main(argc, argv)
int argc;
char *argv[];
{
  int myscreen,ScreenHeight,ScreenWidth;
  int i;
  char text[10];
  int done;
  
  strcpy(display,"");
  getArgs(argc, argv);

  mydisplay = XOpenDisplay(display);
  if (mydisplay == NULL) {
    if (strcmp(display,""))
      fprintf(stderr,"Can't open display: %s\n",display);
    else
      fprintf(stderr,"Can't open default display\n");
    exit(1);
  }

  myscreen = DefaultScreen(mydisplay);
  ScreenHeight = DisplayHeight(mydisplay,myscreen) - 40;
  ScreenWidth = DisplayWidth(mydisplay,myscreen) -1;

  determineSize();
  printf("Image size (%d,%d)\n",columns,rows);

  screenWidth= columns*Factor+1;
  screenHeight= rows*Factor+1+TitleHeight;
  {
    int x,y;
    for (y=0;y<300;y++)
      for(x=0;x<300;x++)
	image[y][x]=0;
  }
  
  mybackground = WhitePixel(mydisplay, myscreen);
  myforeground = BlackPixel(mydisplay, myscreen);
  
  myhint.x = 0; myhint.y = 0;
  myhint.width = screenWidth; myhint.height = screenHeight;
  myhint.flags = PPosition | PSize;
  
  mywindow = XCreateSimpleWindow(mydisplay,
				 DefaultRootWindow(mydisplay),
				 myhint.x, myhint.y,
				 screenWidth, screenHeight,
				 5, myforeground, mybackground);
  
  XSetStandardProperties(mydisplay, mywindow, filename, filename,
			 None, argv, argc, &myhint);
  mygc = XCreateGC(mydisplay, mywindow, 0, 0);
  XSetBackground(mydisplay, mygc, mybackground);
  XSetForeground(mydisplay, mygc, myforeground);
  XSelectInput(mydisplay, mywindow,
	       ButtonPressMask | KeyPressMask | ExposureMask);
  XMapRaised(mydisplay, mywindow);
  XMapWindow(mydisplay,mywindow);

  done = 0;
  
  while (!done) {
    XNextEvent(mydisplay, &myevent);
    switch (myevent.type) {
    case Expose:
      if (myevent.xexpose.count == 0) 
	MyDrawProcedure();
      break;

    case KeyPress:
      i = XLookupString( &myevent.xkey, text, 10, &mykey, 0);
      if (i == 1 && text[0] == 'q') done = 1;
      break;
    }
  }
  XFreeGC(mydisplay, mygc);
  XDestroyWindow(mydisplay, mywindow);
  XCloseDisplay(mydisplay);
  exit(0);
}

void showPoint(x,y)
int x,y;
{
  int shift;

  if (image[y][x] != 1) 
    {
    image[y][x]=1;
    pointsDisplayed++;
  }
  if (Factor == 1)
    XDrawPoint(  mydisplay, mywindow, mygc,
	       Factor*x, 
	       Factor*(rows-y)+TitleHeight);
  else
    if(Hexagonal){
      shift = (y-rows/2)*(Factor/2);
      XDrawRectangle(  mydisplay, mywindow, mygc,
		     Factor*x+shift, 
		     Factor*(rows-y)+TitleHeight,
		     Factor-1, Factor-1); 
    }
    else
      XDrawRectangle(  mydisplay, mywindow, mygc,
		     Factor*x, 
		     Factor*(rows-y)+TitleHeight,
		     Factor-1, Factor-1); 
}

void hidePoint(x,y)
int x,y;
{
  int shift;

  if (image[y][x] !=0) pointsDisplayed--;
  image[y][x] = 0;
  XSetForeground(mydisplay, mygc, mybackground);
  XSetBackground(mydisplay, mygc, myforeground);
  if (Factor == 1)
    XDrawPoint(  mydisplay, mywindow, mygc,
	       Factor*x, 
	       Factor*(rows-y)+TitleHeight);
  else
    if(Hexagonal){
      shift = (y-rows/2)*(Factor/2);
      XDrawRectangle(  mydisplay, mywindow, mygc,
		     Factor*x+shift, 
		     Factor*(rows-y)+TitleHeight,
		     Factor-1, Factor-1); 
    }
    else
      XDrawRectangle(  mydisplay, mywindow, mygc,
		     Factor*x, 
		     Factor*(rows-y)+TitleHeight,
		     Factor-1, Factor-1); 
  XSetBackground(mydisplay, mygc, mybackground);
  XSetForeground(mydisplay, mygc, myforeground);
}

MyDrawProcedure()
{
  int x,y;
  int origPoints;
  float bioc;
  char c;
  char time[10];

  fp=fopen(filename, "r");
  pointsDisplayed=0;
  XClearWindow(mydisplay,mywindow);
  XDrawRectangle(  mydisplay, mywindow, mygc,
		   0,TitleHeight-2,screenWidth-1,0);

  for ( y=rows-1; y>=0; y--) {
    while ((c=getc(fp)) !=':' && c!=EOF); /* skip to beginning of line */
    for(x=0;x < columns; x++){
      if (fscanf(fp,"%f",&bioc) == EOF) break;
      if (bioc >=  LowerThreshold && bioc <= UpperThreshold)
	showPoint(x,y);
    }
    while ((c=getc(fp)) !='\n' && c!=EOF); /* skip to end of line */
    line++;
  }
  XFlush(mydisplay);
  fprintf(stdout,"Number of points displayed = %d\n", pointsDisplayed);
  origPoints= pointsDisplayed;
  CountPoints();
  while((c=getc(fp)) != EOF) {
    if (c=='T' || c =='t') {
      fscanf(fp,"ime = %s",time);
      XDrawImageString(mydisplay,mywindow,mygc,8,12,"Time",strlen("Time")); 
      XDrawImageString(mydisplay,mywindow,mygc,38,12,time,strlen(time)); 
    }
    if (c == '@')
      for ( pointsDisplayed = 0, y=rows-1; y>=0; y--) {
	while ((c=getc(fp)) !=':' && c!=EOF); /* skip to beginning of line */
	for(x=0;x < columns; x++){
	  if (fscanf(fp,"%f",&bioc) == EOF) break;
	  if (bioc >=  LowerThreshold && bioc <= UpperThreshold)
	    showPoint(x,y);
	  else hidePoint(x,y);
	}
	while ((c=getc(fp)) !='\n' && c!=EOF); /* skip to end of line */
	line++;
      }
    if (c!='(') 
      while ((c=getc(fp)) !='(' && c!=EOF); /* skip to beginning of line */
    if (fscanf(fp,"%d,%d) %f",&x,&y,&bioc) == EOF) break;
    if (bioc >=  LowerThreshold && bioc <= UpperThreshold)
      showPoint(x,y);
    else hidePoint(x,y);
    while ((c=getc(fp)) !='\n' && c!=EOF); /* skip to end of line */
    line++;
  }
  XFlush(mydisplay);
  printf(" Image complete with points displayed = %d\n", pointsDisplayed);
  CountPoints();
  fclose(fp);
}

getArgs(argc, argv) 
     int argc;
     char **argv;
{
  int argx;

  Skip =0;
  Factor = 1;
  rows = 0;
  Hexagonal =0;

  argx=1;
  if (argc == 1) {
    fprintf(stdout,"Usage: %s -f <input-file> -l <lower-bound> -u <upper-bound> [-hexagonal] [-size <size-factor>] [-mageRows <rows-in-each-subframe>] [-display DISPLAY]\n", argv[0]);
    exit(-1);
  }
  while (argx <argc) {
    switch (argv[argx][1] ) {
      case 'f':
	strcpy( filename, argv[++argx]);
	fprintf(stdout,"Input file name: %s\n", filename);
	break;
      case 'l':
	sscanf(argv[++argx], "%f", &LowerThreshold);
	fprintf(stdout,"Lower Threshold: %f\n", LowerThreshold);
	break;
      case 'u':
	sscanf(argv[++argx], "%f", &UpperThreshold);
	fprintf(stdout,"Upper Threshold: %f\n", UpperThreshold);
	break;
      case 'h':
	Hexagonal=1;
	Factor =2; /* image size gets doubled to handle hexagonal topology */
	fprintf(stdout,"Hexagonal Geometry\n");
	break;
      case 's':
	sscanf(argv[++argx], "%d", &Factor);
	fprintf(stdout,"Multiplication Factor: %d\n",Factor);
	break;
      case 'm':
	sscanf(argv[++argx], "%d", &rows);
	fprintf(stdout,"Number of rows in each subframe: %d \n", rows);
	break;
      case 'd':
	strcpy( display, argv[++argx]);
	fprintf(stdout,"Displayed on screen: %s\n",display);
	break;
      default:
	fprintf(stderr, "**********unexpected arg: %s**********\n", argv[argx]);
      }
      argx++;
  }

}
