// cosh().

// General includes.
#include "cl_sysdep.h"

// Specification.
#include "cl_complex.h"


// Implementation.

#include "cl_C.h"
#include "cl_real.h"

cl_N cosh (const cl_N& x)
{
// Methode:
// x reell -> klar
// x = a+bi -> (complex (* (cosh a) (cos b)) (* (sinh a) (sin b)))
	if (realp(x)) {
		DeclareType(cl_R,x);
		return cosh(x);
	} else {
		DeclareType(cl_C,x);
		// x=a+bi
		var const cl_R& a = realpart(x);
		var const cl_R& b = imagpart(x);
		var cl_cos_sin_t trig_b = cl_cos_sin(b); // cos(b), sin(b) errechnen
		var cl_cosh_sinh_t hyp_a = cl_cosh_sinh(a); // cosh(a), sinh(a) errechnen
		return complex(hyp_a.cosh * trig_b.cos, // cosh(a)*cos(b)
			       hyp_a.sinh * trig_b.sin // sinh(a)*sin(b)
			      );
	}
}
