#define R_SOL	0
#define R_RHS	1
#define R_DIAG	2
#define R_STIFF	2
#define R_CGD	3
#define R_CGG	4
#define R_CGH	5

#define R_RES	3
#define R_RQ	4

#define R_XSAVE	4
#define R_YSAVE	5
#define R_SOLSAVE	6
#define R_ILU	9

#define R_TRX   10
#define R_TRY   11
#define R_TRZ   12
#define R_AREA   7
#define R_AREA1  9
#define R_AREA2 11
#define R_BPX   13
#define R_RS     8
#define R_RS1   10
#define R_RS2   12

#define E_TPART	4
#define E_THOM	5
#define E_TOPT	6

#define R_MAXPT  13
#define R_MAXEDG 14
#define R_MAXTR	3

#define R_GX 0
#define R_GY 1
#define R_GNORM 2



#define LISTLIST	0
#define PTVEC		1
#define EDGVEC		2
#define TRVEC		3
#define LOCALSTIFF	4
#define SPARSE_SMALL	5
#define SPARSE_MEDIUM	6
#define SPARSE_LARGE	7
#define LISTELEM	8
#define PTELEM		9
#define EDGELEM		10
#define TRELEM		11
#define BOUNDELEM   12
#define MAXLISTS	13
#define NOLIST		-1

struct _ELEM
  {
    PTR pt;
    struct _ELEM *next;
  };
typedef struct _ELEM  PTRELEM;
typedef PTRELEM*      PTRLIST;
typedef int           LIST;

struct BOUNDARY
  {
    REAL x,y;
    struct BOUNDARY *next;
  };
typedef struct BOUNDARY BOUNDARY;

struct NEIGHBOR
  {
    struct PT	*p;
	REAL		stiff, ilu;
  };
typedef struct NEIGHBOR NEIGHBOR;
  
struct PT
  {
	REAL        *vec;
    int			boundP, indexP, counterP, level, mark, class;
    REAL		x,y;
	int			noOfNeighbors, maxNeighbors;
	struct NEIGHBOR	*neighbors;
    struct PT	*next,*last;
  };
typedef struct PT  PT;

struct EDG
  {
    REAL        *vec;
    int	        boundP, type, level, class, mark, counter;
    struct PT	*p1,*p2,*pm;
    struct TR	*t1,*t2;
    PT			*(*MidPoint)();
    BOUNDARY    *bound;
    struct EDG *next,*last,*father,*firstSon;
  };
typedef struct EDG EDG;

struct TR
  {
	REAL        *vec;
    struct PT	*p1,*p2,*p3;
    struct EDG	*e1,*e2,*e3;
    PTR			user;
    struct TR	*next,*last,*father,*firstSon, *partner;
    int			type, level, class, depth, mark;
  };
typedef struct TR  TR;
 
struct TRIANGULATION
  {
    char    *name;
    char    *fileName;
    int		noOfPoints, noOfEdges, noOfTriangles,
			refLevel, maxDepth, iluAvailable,
			noOfInitPoints, noOfInitEdges, noOfInitTriangles;
    PTR     problem, assemble, matrix, solve, plot, windows;
    PROC    NewP, NewE, NewT, ReturnP, ReturnE, ReturnT;
    PT      *firstPoint, *lastPoint, *initPoints, *lastDirectPoint;
    EDG     *firstEdge, *lastEdge, *firstGreenEdge, *initEdges;
    TR      *firstTriangle, *lastTriangle, *firstGreenTriangle,
			*initTriangles;
    PTRLIST *lists;
	struct TRIANGULATION *next;
  };
typedef struct TRIANGULATION TRIANGULATION;
 
#define allReds -1
#define allGreens -2
#define all -3
#define allBackward -4
#define initial -5
#define boundInit -6
#define boundHier -7
#define boundNodal -8
#define quadraticExtension -9
#define nodal -10
#define nonBound -11
#define previous -12
#define dirichlet -13
#define direct -14
#define nonDirect -15
#define nullBound -16
#define sonsOfRed -17
 
#define INTERIOR  1
#define DIRICHLET 2
#define NEUMANN   3
#define CAUCHY    4
#define T_WHITE 0
#define T_GREEN 1
#define T_RED 2
#define T_BLUE 3
#define T_NOTHING 4
#define EXACT    0
#define TRIANGUL 1
 
extern	int		InitTri();
extern	TRIANGULATION	*CrTri();
extern	int		SelTri();
extern	int		CloseTri();

extern	int		ApplyP();
extern	int		ApplyE();
extern	int		ApplyT();
extern	int		ApplyPLevel();
extern	int		ApplyELevel();
extern	int		ApplyTLevel();

extern	int		OpenRef();
extern	int		RefTr();
extern	int		CloseRef();

extern	PT		*StdMidPoint();
extern	PT		*ArcMidPoint();
extern	void	SetTP();
extern	void	SetTE();

extern	PT			*NewP();
extern	void		ReturnP();
extern	EDG			*NewE();
extern	void		ReturnE();
extern	TR			*New4T();
extern	void		Return4T();
extern	int			MkGreen();
extern	EDG			*RefineEdg();

extern	void		PrintTR();

extern TRIANGULATION *actTriang, *firstTriang;

#define TFIRSTSON(t) ((t)->firstSon)
#define TRED1SON(t) ((t)->firstSon)
#define TRED2SON(t) (&(((t)->firstSon)[1]))
#define TRED3SON(t) (&(((t)->firstSon)[2]))
#define TRED4SON(t) (&(((t)->firstSon)[3]))
#define RA(p,ind) (((p)->vec)[ind])
#define RD(p,ind) (((p).vec)[ind])
#define GREENEDGE(t)((((t)->firstSon)->e3))
#define NEIGH_TR(ed,t) (((ed->t1)==t)?(ed->t2):(ed->t1))
#define NEIGHBOR1(t)((((((t)->e1)->t1)==(t))?((t)->e1)->t2:((t)->e1)->t1))
#define NEIGHBOR2(t)((((((t)->e2)->t1)==(t))?((t)->e2)->t2:((t)->e2)->t1))
#define NEIGHBOR3(t)((((((t)->e3)->t1)==(t))?((t)->e3)->t2:((t)->e3)->t1))
#define NEIGHBORK(t,k)((((((&((t)->e1))[k])->t1)==(t))?((&((t)->e1))[k])->t2:((&((t)->e1))[k])->t1))
#define EFIRSTSON(ed) ((ed)->firstSon)
#define ESECONDSON(ed) (((ed)->firstSon)->next)
#define ESONSP(ed) (((ed)->firstSon)!=nil)
#define PM(ed) ((ed)->pm)
#define MID(t) ((((t)->firstSon)->e3)->t2)
#define OPPO_EDG(t,ed) ((((t)->e1)==(ed))?(t)->p1:((((t)->e2)==(ed))?(t)->p2:(t)->p3))
#define OPPO_PT(t,p) ((((t)->p1)==(p))?(t)->e1:((((t)->p2)==(p))?(t)->e2:(t)->e3))
#define SON_AT(ed,p) ((((ed)->p1)==(p))?(ed)->firstSon:((ed)->firstSon)->next)
#define SON_NOT_AT(ed,p) ((((ed)->p1)!=(p))?(ed)->firstSon:((ed)->firstSon)->next)
#define OTHER_EDG(t,ed1,ed2) (((((t)->e1)!=(ed1))&&(((t)->e1)!=(ed2)))?(t)->e1:((((t)->e2)!=(ed1))&&(((t)->e2)!=(ed2)))?(t)->e2:(t)->e3)
#define OTHER_PT(t,p1,p2) (((((t)->p1)!=(p1))&&(((t)->p1)!=(p2)))?(t)->p1:((((t)->p2)!=(p1))&&(((t)->p2)!=(p2)))?(t)->p2:(t)->p3)
#define COMMON_PT(ed1,ed2) (((((ed1)->p1)==((ed2)->p1))||(((ed1)->p1)==((ed2)->p2)))?(ed1)->p1:(ed1)->p2)
#define PT_IN_EDG(p,ed) (((ed->p1)==p)||((ed->p2)==p))
#define PT_IN_TR(p,t) (((t->p1)==p)||((t->p2)==p)||((t->p3)==p))
#define EDG_IN_TR(ed,t) (((t->e1)==ed)||((t->e2)==ed)||((t->e3)==ed))
