/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/

#include <stdio.h>

#include <time.h>
#include <stdlib.h>
#include <events.h>

#include "kask.h"
#include "kaskevnt.h"
#include "kaskcmd.h"

long allocMem = 0L;

static KaskEvent ZIBEv;

void *ZIBAlloc(size)
  long size;
  {
    void *buf;
    buf = (void*)malloc(size);
	if (buf!=nil) allocMem += size;
    return buf;
  }

void ZIBFree(buf)
  void *buf;
  {
    free(buf);
	return;
  }
  
REAL ZIBSeconds()
  {
    clock_t t = clock();
	REAL x = t;

	return x/CLOCKS_PER_SEC;
  }

int ZIBReadFile(name,buffer)
  char *name, **buffer;
  {
    FILE *fd;
	long textLng;
	int rc;

	fd = fopen(name,"r");
	if (fd==nil)
	  { 
		sprintf(globBuf,"File '%s' could not be opened\n",
				name);
		ZIBStdOut(globBuf);
		return false;
	  }
	rc = fseek(fd, 0L, 2);
	if (rc!=0)
	  {
	    sprintf(globBuf,"fseek failed on %s\n",name);
		ZIBStdOut(globBuf);
		fclose(fd);
		*buffer = nil;
		return false;
	  }
	textLng = ftell(fd);
	rewind(fd);
	*buffer = ZIBAlloc(textLng+10L);
	if (*buffer==nil)
	  {
		sprintf(globBuf,"Not enough memory to store %ld bytes of '%s'\n",
					textLng, name);
		ZIBStdOut(globBuf);
		fclose(fd);
		*buffer = nil;
		return false;
	  }
	textLng = fread(*buffer,1L,textLng,fd);
	(*buffer)[textLng] = '\0';
	fclose(fd);

	return true;
  }

static FILE *outFile = nil;

void ZIBNL()
  {
    putc('\n',outFile);
	return;
  }

void ZIBStdOut(s)
  char *s;
  {
	if (outFile==nil) outFile = fopen("test.output","w");
	if (outFile==nil)
	  {
	    printf("Nothalt, 'test.output' already opened?\n");
	    exit(2);
	  }
    fputs(s,outFile);
	return;
  }

KaskEvent *ZIBEvent()
  {
    ZIBEv.type = QuitEvent;
	return &ZIBEv;
  }
