/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#if(0)
  FTANGLE v1.13, tangled with SunOS/UNIX on "Tuesday, July 24, 1990 at 22:35." 
  COMMAND LINE: "ftangle params -#"
  RUN TIME: "Tuesday, September 4, 1990 at 14:23."
  WEB FILE NAME: "params.web"
  CHANGE FILE NAME: "/dev/null"
#endif



#define DOUBLE_INITIALIZED\
{ ZIBStdOut("Parameter module double initialized\n"); return false;}
#define NOT_ENOUGH_MEMORY(NO)\
{ sprintf(globBuf,"Not enough memory (%d)\n",NO); ZIBStdOut(globBuf); return false; }
#define ALREADY_DEFINED(LIST)\
{ sprintf(globBuf,"'%s' is already used as a parameter list name\n",LIST);\
ZIBStdOut(globBuf); return nil;}
#define TO_MANY_PARLISTS(LIST)\
{ sprintf(globBuf,"More than %d parameter list, could not enter '%s'\n",\
parListLng,LIST); ZIBStdOut(globBuf); return nil; }
#define NO_PARAM_SPACE(N,SIZE,LIST)\
{ sprintf(globBuf,"Can't allocate %d element of size %d for list '%s'\n",\
N,SIZE,LIST); ZIBStdOut(globBuf); return nil; }
#define NO_LIST(LIST)\
{ sprintf(globBuf,"Parameter list '%s' not defined\n",LIST); ZIBStdOut(globBuf); return false; }
#define NO_NAME(LIST,NAME)\
{ sprintf(globBuf,"'%s' not found in parameter list '%s'\n",NAME,LIST);\
ZIBStdOut(globBuf); return false; }




#include <stdio.h>
#include <string.h>

#include "kask.h"

#define SETZERO(P,N)\
for (stat_ind= 0;stat_ind<(N);stat_ind++)((char*)P)[stat_ind]= '\0';
#define COPYVALUE(F,T,N)\
for (stat_ind= 0;stat_ind<(N);stat_ind++)((char*)T)[stat_ind]= ((char*)F)[stat_ind];

#define MAXPARAMS 100

struct paramList
{
char*listName,**parNames;
int noOfParams,valueSize,valueType;
PTR values;
PROC UserParamChanged,UserListChanged;
};
typedef struct paramList paramList;



static paramList**pLists= nil;
static char**pNames= nil;
static int parListLng= 0;
static int stat_ind;




static int CheckListName(listName)
char*listName;
{
int k;

if(pLists==nil)
{InitParamLists(MAXPARAMS);return-1;}
for(k= 0;k<parListLng;k++)
{
if(pLists[k]==nil)continue;
if(strcmp(listName,pLists[k]->listName)==0)break;
}
return(k==parListLng)?-1:k;
}



static int CheckList(name,names,n)
char*name,**names;
int n;
{
int k,pos;

if(names)
{
for(k= 0;k<n;k++)
{
if(names[k]==nil)continue;
if(strcmp(name,names[k])==0)break;
}
if(k<n)return k;
}
if(sscanf(name,"%d",&pos)!=1)return-1;
return((pos<0)||(pos>=n))?-1:pos;
}



static char*CopyString(s)
char*s;
{
int lng= strlen(s);
char*c= (char*)ZIBAlloc((long)lng);

if(c==nil)NOT_ENOUGH_MEMORY(4);
return strcpy(c,s);
}

static void ReleaseString(s)
PTR s;
{
ZIBFree(s);
return;
}






int InitParamLists(maxParams)
int maxParams;
{
int k;

if(pLists)DOUBLE_INITIALIZED;

pLists= 
(paramList**)ZIBAlloc((long)(maxParams*sizeof(paramList*)));
if(pLists==nil)NOT_ENOUGH_MEMORY(1)

pNames= (char**)ZIBAlloc((long)(maxParams*sizeof(char*)));
if(pNames==nil)NOT_ENOUGH_MEMORY(2)

for(k= 0;k<maxParams;k++)
{pLists[k]= nil;pNames[k]= nil;}
parListLng= maxParams;
return true;
}




PTR NewParamList(listName,noOfParams,valueSize,valueType,names,
UserParamChanged,UserListChanged)
char*listName,**names;
int noOfParams,valueSize,valueType;
PROC UserParamChanged,UserListChanged;
{
int k;
paramList*pL;

k= CheckListName(listName);
if(k>=0)ALREADY_DEFINED(listName)

for(k= 0;k<parListLng;k++)
if(pLists[k]==nil)break;
if(parListLng==k)TO_MANY_PARLISTS(listName)

pL= (paramList*)ZIBAlloc((long)(sizeof(paramList)));
if(pL==nil)NOT_ENOUGH_MEMORY(3)

pL->listName= CopyString(listName);
if(pL->listName==nil)return nil;
pL->values= (PTR)ZIBAlloc((long)(noOfParams*valueSize));
if(pL->values==nil)
NO_PARAM_SPACE(noOfParams,valueSize,listName)
SETZERO(pL->values,noOfParams*valueSize);

pL->parNames= names;
pL->noOfParams= noOfParams;
pL->valueSize= valueSize;
pL->UserParamChanged= UserParamChanged;
pL->UserListChanged= UserListChanged;
pL->valueType= valueType;

pLists[k]= pL;
pNames[k]= pL->listName;
return pL->values;
}




int ReturnParamList(listName)
char*listName;
{
int k;
paramList*pL;

k= CheckListName(listName);
if(k<0)NO_LIST(listName)
pL= pLists[k];

ZIBFree((PTR)(pL->values));
ReleaseString((PTR)pL->listName);
SETZERO((char*)pL,sizeof(paramList));

ZIBFree((PTR)pL);
pLists[k]= nil;
pNames[k]= nil;

return true;
}




int GetParamList(listName,names,values,noOfParams,valueType)
char*listName,***names;
PTR*values;
int*noOfParams,*valueType;
{
int k;
paramList*pL;

k= CheckListName(listName);
if(k<0)NO_LIST(listName)
pL= pLists[k];

*names= pL->parNames;
*values= pL->values;
*noOfParams= pL->noOfParams;
*valueType= pL->valueType;

return true;
}




int GetParam(listName,name,value)
char*listName,*name;
PTR value;
{
int i,k;
paramList*pL;

k= CheckListName(listName);
if(k<0)NO_LIST(listName)
pL= pLists[k];

i= CheckList(name,pL->parNames,pL->noOfParams);
if(i<0)NO_NAME(listName,name)

COPYVALUE(&((char*)pL->values)[i*(pL->valueSize)],value,pL->valueSize);

return true;
}




char**GetListNames(lng)
int*lng;
{
if(pLists==nil)InitParamLists(MAXPARAMS);
*lng= parListLng;
return pNames;
}




int ChangeParam(nameList,name,value)
char*nameList,*name;
PTR value;
{
int i,k;
paramList*pL;

k= CheckListName(nameList);
if(k<0)NO_LIST(nameList)
pL= pLists[k];

i= CheckList(name,pL->parNames,pL->noOfParams);
if(i<0)NO_NAME(nameList,name)

COPYVALUE(value,&((char*)pL->values)[i*(pL->valueSize)],pL->valueSize);

if(pL->UserParamChanged)
return(pL->UserParamChanged)(nameList,name,i);
else return true;
}




int ChangedParamList(nameList)
char*nameList;
{
int k;
paramList*pL;

k= CheckListName(nameList);
if(k<0)NO_LIST(nameList)
pL= pLists[k];

if(pL->UserListChanged)
return(pL->UserListChanged)(nameList);
else return true;
}






