#############################################################################
##
#A  module.g                    GAP library                    J\"urgen Mnich
##
#A  @(#)$Id: module.g,v 3.3 1992/03/17 12:31:20 jmnich Rel $
##
#Y  Copyright 1990-1992,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
##
##  This file contains all polymorph functions for modules.
##
#H  $Log: module.g,v $
#H  Revision 3.3  1992/03/17  12:31:20  jmnich
#H  minor style changes, more bug fixes
#H
#H  Revision 3.2  1992/02/29  13:25:11  jmnich
#H  general library review, some bug fixes
#H
#H  Revision 3.1  1992/02/12  15:37:22  martin
#H  initial revision under RCS
#H
##


#############################################################################
##
#F  InfoModule1(...)  . . . . . . . . . . . . . . . . . . package information
#F  InfoModule2(...)  . . . . . . . . . . . . . . . package debug information
##
if not IsBound( InfoModule1 )  then  InfoModule1 := Ignore;  fi;
if not IsBound( InfoModule2 )  then  InfoModule2 := Ignore;  fi;


#############################################################################
##
#V  ModuleOps . . . . . . . . . . . . . . . . . operations record for modules
##
ModuleOps := ShallowCopy( DomainOps );


#############################################################################
##
#F  ModuleOps.Print( <obj> )  . . . . . . . . . . . . . . . .  print a module
##
ModuleOps.Print := function( M )
    if IsBound( M.name ) then
        Print( M.name );
    else
        Print( "Module( ", M.ring, ", ", M.abelianGroup, " )" );
    fi;
end;


#############################################################################
##
#F  Module( <ring>, <abelianGroup> )  . . . . . . . . . . . . create a module
##
##  This function creates a module as \GAP object with <ring> acting from the
##  right  on  <abelianGroup>.   Recall  that  this  operation has to be well
##  defined,  i.e.  <abelianGroup> has to be closed under multiplication from
##  the right with elements of <ring>.
##
Module := function( arg )
    local   ring, group;

    if Length( arg ) = 2 then
        ring  := arg[1];
        group := arg[2];
    else
        Error( "usage: Module( <ring>, <abelianGroup> )" );
    fi;

    # handle the (linear algebra) case where a ring acts on a row space

    if IsRowSpace( group ) then
        return RowModule( ring, group );
    fi;

    # setup the module record

    return rec(
        abelianGroup := group,
        ring         := ring,
        isModule     := true,
        isDomain     := true,
        isFinite     := IsFinite( group ),
        operations   := ModuleOps
    );
end;


#############################################################################
##
#F  IsModule( <obj> ) . . . . . . . . . . . . . test if an object is a module
##
IsModule := function( obj )
    return IsRec( obj )
        and IsBound( obj.isModule ) and obj.IsModule;
end;


#############################################################################
##
#E  Emacs . . . . . . . . . . . . . . . . . . . . . . . local emacs variables
##
##  Local Variables:
##  mode:               outline
##  outline-regexp:     "#F\\|#V\\|#E"
##  fill-column:        73
##  fill-prefix:        "##  "
##  eval:               (hide-body)
##  End:
##
