/* constants used in p-quotient program */

#ifndef __PQ_CONSTANTS__
#define __PQ_CONSTANTS__

#define PQSPACE 1000000        /* space allocated for computation in array y */
#define MAXWORD 1000           /* maximum length of word */
#define MAXCLASS 63            /* maximum class for p-quotient */
#define MAXGENS 255            /* maximum number of generators for pcp */
#define STACK_SIZE 30000       /* dimension of collection stack */
#define DEFAULT_CLASS 10       /* default class bound for computation */
#define LINK_SOLUBLE_FLAG -1   /* flag in CAYLEY or GAP output file indicating
                                  soluble stabiliser */
#define ALL 999                /* step size flag to indicate that all
				  descendants should be constructed */
#if !defined (IBM)
#define INT_MIN -0x80000000   /* these values are defined in <limits.h>
				 but the header file may not be present */
#define INT_MAX 0x7FFFFFFF
#endif

#define PQ 1                   /* two algorithms */
#define PGA 2

#define MIN_PRINT 0            /* print flags */
#define DEFAULT_PRINT 1
#define INTERMEDIATE_PRINT 2
#define MAX_PRINT 3

#define MAX_STANDARD_PRINT 2   /* print flags for standard presentation */
#define DEFAULT_STANDARD_PRINT 1
#define MIN_STANDARD_PRINT 0

#define BASIC 1                /* input formats for presentation and words */
#define PRETTY 2
#define FILE_INPUT 3

#define FAILURE 0              /* computation failed */
#define SUCCESS 1              /* successful computation */

#endif 
