#include "aglobals.h"
#include "hash.h"
#include "symtab.h"

/*
#define NAME_MAX 32
#define MAXSYM 127

typedef struct symtabentry {
	char name[NAME_MAX+1];
	TYPE type;
	int value1;
	int value2;
	void *object;
	void *etype;
	int level;
} symbol;
*/

static HASH_TAB *symtab;

int cmp ( symbol *sym1, symbol *sym2 )
{
	return strcmp ( sym1->name, sym2->name );
}

void init_sym_tab ( void )
{
	symtab = maketab ( MAXSYM, hash_pjw, cmp );
}

symbol *new_symbol ( char *name, int scope )
{
	symbol *sym_p;
	
	sym_p = (symbol *)newsym ( sizeof ( symbol ) );
	strncpy ( sym_p->name, name, sizeof ( sym_p->name ) );
	sym_p->type = NOTYPE;
	sym_p->value1 = sym_p->value2 = 0;
	sym_p->object = sym_p->etype = NULL;
	sym_p->level = scope;
	
	return ( sym_p );
}

symbol *add_symbol ( symbol *sym )
{
	return (symbol *)addsym ( symtab, sym );
}

symbol *find_symbol ( char *symname )
{
	return (symbol *)findsym ( symtab, symname );
}

void symprint ( symbol *sym, FILE *stream )
{
	char stype[32];
	
	switch ( sym->type ) {
		case INT:
				strcpy ( stype, "INT" );
				break;
		case GROUP:
				strcpy ( stype, "GROUP" );
				break;
		case PCGROUP:
				strcpy ( stype, "PCGROUP" );
				break;
		case GROUPRING:
				strcpy ( stype, "GROUPRING" );
				break;
		case GRELEMENT:
				strcpy ( stype, "GRELEMENT" );
				break;
		case VECTORSPACE:
				strcpy ( stype, "VECTORSPACE" );
				break;
		case DLIST:
				strcpy ( stype, "DLIST" );
				break;
		case HOMREC:
				strcpy ( stype, "HOMREC" );
				break;
		default:
				strcpy ( stype, "NOTYPE" );
	}
	fprintf ( stream, "%-32s of type %s\n", sym->name, stype );
}

void show_symbols ( void )
{
	ptab ( symtab, symprint, stdout, TRUE );
}
	
















