/* $Header: /usr/src/local/imps/src/xdg/RCS/parse.c,v 1.1 90/11/02 11:33:00 ramsdell Exp $ */

#include "scan.h"
#include "store.h"
#include "parse.h"
#include <stdio.h>
#include <ctype.h>
#include <setjmp.h>

static jmp_buf parse_exit;

/* Parse error message generator. */
void parse_error(message)
#if defined __STDC__
     const
#endif
     char *message;
{
  if (scanned_text[0] != '\0')
    warning("Last symbol read was %s.\n", scanned_text);
  warning("Parse error on line %d: %s.\n", line_number, message);
  longjmp(parse_exit, 1);
}

#if defined __STDC__
static data make_atom(void)
#else
static data make_atom()
#endif
{
  int n;
  char *s = scanned_text;
  if (*s == '-') s++;
  for(; *s != '\0'; s++)
    if (!isdigit(*s))
      return make_string(scanned_text);
  if (1!=sscanf(scanned_text, "%d", &n))
    parse_error("cannot parse number");
  return make_number(n);
}

#if defined __STDC__
static data parse_list(void);
#else
static data parse_list();
#endif

static data parse_rest(result)
     data result;
{
  data d = make_pair(result, NIL);
  result = d;
  while (1) {
    switch (scan()) {
    case ATOM:
      data_tail(d) = make_pair(make_atom(),NIL);
      d = data_tail(d);
      break;
    case '(': 
      data_tail(d) = make_pair(parse_list(),NIL);
      d = data_tail(d);
      break;
    case ')': return result;
    case EOF: parse_error("unexpected EOF");
    }
  }
}

#if defined __STDC__
static data parse_list(void)
#else
static data parse_list()
#endif
{
  switch (scan()) {
  case ATOM: return parse_rest(make_atom());
  case '(': return parse_rest(parse_list());
  case ')': return NIL;
  case EOF: parse_error("unexpected EOF");
  }
}

/* Parse:
   Returns 1 on success and sets arg.
   Returns 0 on EOF.
   Returns -1 on error.
*/

int parse(dp)
     data *dp;
{
  scanned_text[0] = '\0';
  if (setjmp(parse_exit) == 0)
    switch (scan()) {
    case ATOM: *dp = make_atom(); return 1;
    case '(': *dp = parse_list(); return 1;
    case EOF: *dp = NIL; return 0;
    case ')': parse_error("right parenthesis found at start of parse");
    }
  return -1;
}
