;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994



(herald patch)

(load '(presentation special-effects) imps-impl-env)

(load '(presentation forall-patch) imps-impl-env)

(comment
 (define (CHANGE-BOUND-VARIABLES-SELECTIVELY expr do-vars avoid-vars)
   (let ((subst (make-variable-renaming
		 (bound-variables expr)
		 (set-union (variables expr) avoid-vars))))
     (apply-bound-variable-renaming-selectively subst do-vars expr)))

 (define (APPLY-BOUND-VARIABLE-RENAMING-SELECTIVELY subst do-vars expr)
   ;;subst is assumed to contain ALL bound variables.
   (iterate loop ((expr expr) (bound '()))
	    (cond ((memq? expr (intersection bound do-vars)) (cdr (assq expr subst)))
		  ((formal-symbol? expr) expr)
		  (else
		   (apply
		    (expression-constructor expr)
		    (let ((bound (if (binding-expression? expr)
				     (set-union bound (binding-variables expr))
				   bound)))
		      (map
		       (lambda (x) (loop x bound))
		       (expression-components expr))))))))


 (define (backchain-substitute-at-path
	  paths context assertion
	  context-formula exoscopes local-assumptions)
   (receive (vpath subst)
	    (backchain-select-path-and-subst
	     paths context assertion
	     context-formula exoscopes local-assumptions)
	    (if
		(fail? vpath)
		(backchain-fail)
	      (let ((path-list
		     (expand-virtual-path assertion vpath))
		    (replacement-expr
		     (apply-substitution subst (equivalence-rhs context-formula))))
		(return
		 subst
		 (substitutions-at-paths
		  (change-bound-variables-selectively assertion
						      (free-variables context-formula)
						      (free-variables context-formula))
		  (list replacement-expr)
		  (list path-list))
		 (backchain-make-minors context local-assumptions subst)))))))

;;(load '(presentation print) imps-impl-env)

'patch-done

