;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(define (PRESENT-TEX-QUANTIFICATION-OPERATOR formatter op args bp)
  (let ((weight (presentation-binding-power formatter op))
	(top-level-form
	 (if (list? (presentation-format formatter op))
	     (car (presentation-format formatter op))
	     (presentation-format formatter op)))
	(nested-form (if (list? (presentation-format formatter op))
			 (cadr (presentation-format formatter op))
			 (presentation-format formatter op))))
    (destructure (((typing body) args))
      (cond
       ((not (> (maximum-nesting-for-logical-expressions) 0))
	(parenthesize-conditionally
	 (> bp weight)
	 `(,nested-form 
	   ,(present-tex-parameter-list typing)
	   " \\quad "
	   ,(present-tree formatter body 0))))
       ((and (eq? op 'forall)
	     (list? body)
	     (eq? (car body) 'implies)
	     (short-sexp? (cadr body)))
	(format-forall-such-that formatter top-level-form typing body))
       (else 
	`(,top-level-form
	  ,(present-tex-parameter-list typing)
	  ," \\quad "
	  ,(present-tree formatter body 0)))))))

(define (format-forall-such-that formatter top-level-form typing body)
  (destructure (((() antecedent consequent) body))
    `(,top-level-form
      ,(present-tex-parameter-list typing)
      " \\quad \\mbox\{s. t.\} \\quad"
      ,(bind (((maximum-nesting-for-logical-expressions) 0))
	(present-tree formatter antecedent 0))
      " , \\newline\\phantom\{X\}"
      ,(present-tree formatter consequent 0))))

  
(lset *small-tex-expression-cutoff* 50)

(define (short-sexp? expr)
  (< (tex-expression-width expr) *small-tex-expression-cutoff*))

(define (TEX-EXPRESSION-WIDTH expr)
  (string-length (format '() "~A" expr)))

(make-presentation-format
 *tex-form* 'forall
 (list " \\forall " "\\forall ")
 present-tex-quantification-operator 50)
