;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald PARSE)


;;; Term* = zero or more comma separated Term's and
;;; Term+ = one or more comma separated Term's.
;;;
;;; An ATOM is a sequence of letters, digits, underscore, and period.
;;;
;;;------------------------
;;; The start symbol is Exp.
;;;
;;; Exp  ::= Aexp                           ; delimited expressions
;;;       |  Exp(Exp*)                      ; function application
;;;       |  Exp Op Exp                     ; binary ops

;;;
;;; Aexp ::= ATOM                           ; vars or numbers or constants.
;;;       |  (Exp)
;;;       |  Binder (Binding* , Exp)        ; binders
;;;       |  if (Exp, Exp, Exp+)            ; conditionals
;;;                                         ; requires an odd number of exprs.
;;;       |  Op(Exp+)                       ; prefix applications
;;;       |  ?Sort                          ;  undefined from sort
;;;       |  #(Exp,Sort)                    ; sort assertion
;;;
;;; Sort ::= ATOM                           ; base sorts
;;;       |  [Sort,Sort+]                   ;nary function constructor
;;;
;;; Binders ::= lambda | forall | forsome | iota | with
;;;
;;; Binding  ::= ATOM+ : Sort
;;;
;;; All but the last element of a binder must be a type assertion.
;;; For binders, the left operand of a type assignment must be a variable.
;;; as an extention, you can declare multiple bindings by giving a
;;; tuple of variables as the left operand.
;;;
;;; precedence look at table below.
;;; 

;  semicolon    terminates input
;  f(x, y)  reads as  (f x y)
;
;  #(a,b)      reads as  (is-defined-in-sort a b) where b is parsed a sort.
;  #(a)      reads as  (is-defined a)
;
;  x and y, x or y, not x  do the obvious thing
;
;  x + y    reads as  (+ x y)     - similarly for * / = < > <= >=
;
;  x - y    reads as (sub x y)
;
;  if(x,y,z)     reads as (if-term x y z)
;  if(x,y,z,w,v) reads as (if-term x y (if-term z w v)) ... etc.
;
;  forall(x,y:s,z,w:t,e) reads as (forall (((x y) s) ((z w) t)) e)
;                where s and t are parsed as sorts.

; Sorts.
;
; (a,b,c,...z)  reads as (a b c ... z)
; [a_1, ...,a_(n-1),a_n] reads as (a_1, ...,a_(n-1),a_n)

(define-structure-type TOKEN
  sexpression-label
  null-call-method
  left-call-method 
  binding-power)

(define (MAKE-OPERATOR parser external-format sexpression-label null-call-method left-call-method binding)
  (let ((token-parameters (make-token)))
    (set (token-sexpression-label token-parameters) sexpression-label)
    (set (token-null-call-method token-parameters) null-call-method)
    (set (token-left-call-method token-parameters)  left-call-method)
    (set (token-binding-power token-parameters) binding)
    (set (table-entry (parser-operator-table parser) external-format) token-parameters)))

(define-integrable (RETRIEVE-TOKEN-PARAMETERS parser token)
  (cond ((table-entry (parser-operator-table parser) token))
	(else (illegal-token-error parser token))))  

(define (SEXPRESSION-LABEL parser token)
  (let ((pars (retrieve-token-parameters parser token)))
    (cond ((token-sexpression-label pars))
	  (else (illegal-token-error parser token)))))

;;;some tokens (mainly -) have more than one intermediate format: in this case
;;;token-sexpression-label must be  a list. I did not put in any check that this is so.

(define (NTH-SEXPRESSION-LABEL parser token n)
  (let ((lab (sexpression-label parser token)))
    (if (list? lab)
	(nth (sexpression-label parser token) n)
	lab)))

(lset *parsing-terminators* '(\, \) = \; == oo))

(define (NULL-CALL-METHOD parser token)
  (if (operator? parser token)
      (let ((next (next-token parser)))
	(if (memq? next *parsing-terminators*) 
	    default-null-call-method
	    (let ((pars (retrieve-token-parameters parser token)))
	      (cond ((token-null-call-method pars))
		    (else default-null-call-method)))))
      (lambda (parser token) (ignore parser) token)))

(define (DEFAULT-NULL-CALL-METHOD parser token)
  (let ((sym (sexpression-label parser token)))
    (if (symbol? sym)
	sym
	token)))

(define (LEFT-CALL-METHOD parser token)
  (let ((pars (retrieve-token-parameters parser token)))
    (cond ((token-left-call-method pars))
	  (else (illegal-token-error parser token)))))

(define (BINDING-POWER parser token)
  (let ((pars (table-entry (parser-operator-table parser) token)))
   (cond (pars (let ((power (token-binding-power pars)))
		 
		 (if (list? power) (car power) power)))
	 (else 200))))

(define (ALTERNATE-BINDING-POWER parser token)
  (let ((pars (table-entry (parser-operator-table parser) token)))
    (cond (pars (let ((power (token-binding-power pars)))
		 
		  (if (list? power) (cadr power) power)))
	  (else 200))))

(define (OPERATOR? parser token)
 (table-entry (parser-operator-table parser) token))

(define (PARSE-DOWNWARD parser binding)
  (iterate loop ((parse-tree (let ((token (input-next-token parser)))
				   ((null-call-method parser token) parser token))))
    (if (>= binding (binding-power parser (next-token parser)))
	parse-tree
	(let ((token (input-next-token parser)))
	  (loop ((left-call-method parser token) parser token parse-tree))))))

(define (PARSE-MATCHING-OPERATOR parser match) 
  (cond ((eq? match (next-token parser)) (input-next-token parser) nil)
	(else
	 (iterate loop ((parse-tree-list `(,(parse-matching-binding parser '\,))))
	   (cond ((eq? match (next-token parser))
		  (input-next-token parser) (reverse parse-tree-list))
		 ((not (eq? '\, (input-next-token parser)))
		  (report-error parser "Expecting \",\" or \"~A\"." match))
		 (else
		  (loop (cons (parse-matching-binding parser '\,) parse-tree-list))))))))


(define (PARSE-MATCHING-BINDING parser op)
  (parse-downward parser (binding-power parser op)))

(define (LOGLIKE-OPERATOR-METHOD parser op)
 `(,(sexpression-label parser op) ,(parse-matching-binding parser op)))

(define (PREFIX-OPERATOR-NEXT-TOKEN-CHECK parser op)
  (if (treat-qcs-specially?)
      (if (symbol->quasi-constructor (sexpression-label parser op))
	  (or (eq? (next-token parser) '\{)
	      (eq? (next-token parser) '\() ;; still to be read in the  old way.
	      (report-error parser "~A is a quasi-constructor." op))
	  (or (eq? (next-token parser) '\()
	      (illegal-token-error parser (input-next-token parser))))
      (if (not (eq? (next-token parser) '\())
	  (illegal-token-error parser (input-next-token parser)))))

  
(define (PREFIX-OPERATOR-METHOD parser op)
  
  (prefix-operator-next-token-check parser op)

  (let ((match (if (eq? (next-token parser) '\()
		   '\)
		   '\})))
    (input-next-token parser)
    (let ((args (parse-matching-operator parser match)))
      `(,(sexpression-label parser op) ,@args))))


;;;(define (PREFIX-OPERATOR-METHOD parser op)
;;;  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
;;;  (input-next-token parser)
;;;  (let ((args (parse-matching-operator parser '\) )))
;;;    `(,(sexpression-label parser op) ,@args)))

(define (POSTFIX-OPERATOR-METHOD parser op parse-tree)
 `(,(sexpression-label parser op) ,parse-tree))

(define (INFIX-OPERATOR-METHOD parser op parse-tree)
 `(,(sexpression-label parser op) ,parse-tree ,(parse-matching-binding parser op)))

(define (NARY-INFIX-OPERATOR-METHOD parser op parse-tree)
  (iterate loop ((parse-tree-list (list (parse-matching-binding parser op))))
    (cond ((not (eq? op (next-token parser)))
	   `(,(sexpression-label parser op) ,parse-tree ,@(reverse parse-tree-list)))
	  (else (input-next-token parser)
		(loop (cons (parse-matching-binding parser op) parse-tree-list))))))

(define (RIGHT-ASSOCIATIVE-INFIX-OPERATOR-METHOD parser op parse-tree)
  (labels ((RIGHT-ASSOCIATE
	    (lambda (op a-list)
	      (if (null? (cddr a-list)) `(,op ,(car a-list) ,(cadr a-list))
		  `(,op ,(car a-list) ,(right-associate op (cdr a-list)))))))
    (iterate loop ((parse-tree-list (list (parse-matching-binding parser op))))
      (cond ((not (eq? op (next-token parser)))
	     (right-associate
	      (sexpression-label parser op)
	      (cons parse-tree (reverse parse-tree-list))))
	    (else (input-next-token parser)
		  (loop (cons (parse-matching-binding parser op) parse-tree-list)))))))


(define (NEGATION-OPERATOR-METHOD parser op)
  `(,(nth-sexpression-label parser op 0) ,(parse-downward parser (alternate-binding-power parser op))))

(define (SUBTRACTION-OPERATOR-METHOD parser op parse-tree)
 `(,(nth-sexpression-label parser op 1) ,parse-tree ,(parse-matching-binding parser op)))

(define (NULL-CALL-METHOD-SB parser op)
  (ignore op)
  (let ((match '\]))
  (cond ((eq? match (next-token parser)) (input-next-token parser) nil)
	(else
	 (iterate loop ((parse-tree-list `(,(parse-matching-binding parser '\,)))
			(final-separator '#f))

	   (cond ((eq? match (next-token parser))
		  (input-next-token parser) (reverse parse-tree-list))
		 (final-separator
		  (report-error parser "Expecting \"~A\"" match))
		 ((not (memq? (next-token parser) '(\, ->)))
		  (report-error parser "Expecting \",\" \"->\" or \"~A\"." match))
		 (else
		  (let ((final (eq? (input-next-token parser) '->)))
		    (loop (cons (parse-matching-binding parser '\,) parse-tree-list)
			  final)))))))))

;;;(define (NULL-CALL-METHOD-SB parser op)
;;;  (ignore op)
;;;  (parse-matching-operator parser '\]))

(define (LEFT-CALL-METHOD-LFB parser op parse-tree)
  (or (and (symbol? parse-tree)
	   (symbol->quasi-constructor parse-tree))
      (illegal-token-error parser op))
  `(,parse-tree ,@(parse-matching-operator parser '\})))

(define (NULL-CALL-METHOD-LFB parser op)
  `(,(sexpression-label parser op) ,@(parse-matching-operator parser '\})))

(define (NULL-CALL-METHOD-LP parser op)
  (ignore op)
 (let ((right (parse-matching-operator parser '\) )))
   (if (null? right)
       right
       (car right))))

(define (LEFT-CALL-METHOD-LP parser op parse-tree)
  (ignore op)
  `(,parse-tree ,@(parse-matching-operator parser '\) )))

;;This is for constants such as true and false.

(define (CONSTANT-METHOD parser op) (sexpression-label parser op))


;;;(define (DEFINED-POSTFIX parser op parse-tree)
;;;  `(,(nth-sexpression-label parser op 0) ,parse-tree))
  
(define (DEFINED-IN-SORT-PREFIX parser op)
  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
  (input-next-token parser)
  (let ((args (parse-matching-operator parser '\) )))
    (if (= (length args) 2)
	`(,(nth-sexpression-label parser op 1) ,@args)
	`(,(nth-sexpression-label parser op 0) ,@args))))

(define (NULL-CALL-METHOD-TERMINATOR parser op)
  (ignore op)
  (report-error parser "premature termination of input."))

(define (LEFT-CALL-METHOD-TERMINATOR parser op parse-tree)
  (ignore op)
  (ignore parser)
  (cdr parse-tree))

(define (PARSE-IMPS-COND parser op)
  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
  (input-next-token parser)
  (let ((args (parse-matching-operator parser '\) )))
    (build-conditional parser op args)))

(define (BUILD-CONDITIONAL parser op a-list)
  (or (and (list? a-list) (odd? (length a-list)))
      (report-error parser "Missing alternative in conditional."))
  (cond ((null? (cdr a-list)) (car a-list))
	(else
	`(,(sexpression-label parser op)
	  ,(car a-list)
	  ,(cadr a-list)
	  ,(build-conditional parser op (cddr a-list))))))

(define (PREFIX-SORT-OPERATOR-METHOD parser op)
  (ignore op)
  (if (not (eq? (next-token parser) '\[ )) (illegal-token-error parser (input-next-token parser)))
  (input-next-token parser)
  (let ((args (parse-matching-operator parser '\] )))
    `(,@args unit%sort)))

(define (PREFIX-SORT-DEPENDENT-OPERATOR-METHOD parser op)
  (prefix-operator-next-token-check parser op)
  (let ((match (if (eq? (next-token parser) '\() '\)
		   '\})))
    (input-next-token parser)
    (let ((args (parse-matching-operator parser match)))
      (if (null? args) (no-sort-error parser)
	  (let* ((args (reverse args))
		 (sort (car args)))
	    `(,(sexpression-label parser op) ,@(reverse! (cdr args)) (undefined ,sort )))))))

;;;(define (PREFIX-SORT-DEPENDENT-OPERATOR-METHOD parser op)
;;;  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
;;;  (input-next-token parser)
;;;  (let ((args (parse-matching-operator parser '\) )))
;;;    (if (null? args) (no-sort-error parser)
;;;	(let* ((args (reverse args))
;;;	       (sort (car args)))
;;;	  `(,(sexpression-label parser op) ,@(reverse! (cdr args)) (undefined ,sort ))))))

;;;alternate nicer forms for parsing binding operators:

(define (PARSE-BINDING-OPERATOR parser op)
  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
  (let ((match '\)))
    (input-next-token parser)
    (cond ((eq? match (next-token parser)) (input-next-token parser) nil)
	  (else
	   (iterate loop ((parse-tree-list `(,(parse-matching-binding parser '\,))) (colon? '#f))
	     (if (eq? match (next-token parser))
		 (block (input-next-token parser) 
			`(,op ,@(make-binding parser (reverse parse-tree-list))))
		 (let ((next (input-next-token parser)))
		   (cond ((eq? '\, next)
			  (loop (cons (parse-matching-binding parser '\,) parse-tree-list) '#f))
			 ((and (eq? '\: next) (not colon?))
			  (loop `((\: ,(parse-matching-binding parser '\,))  ,@parse-tree-list) '#t))
			 (else (report-error parser "Bad binding syntax."))))))))))

(define (PARSE-BINDING-OPERATOR-BOTH-SYNTAXES-AUX parser op)
  
  (if (not (eq? (next-token parser) '\()) (illegal-token-error parser (input-next-token parser)))
  (input-next-token parser)
  (let ((next (next-token parser)))
    (if (eq? next '\[)
	(let ((args (parse-matching-operator parser '\) )))
	  `(,(sexpression-label parser op) ,@args))

	
	(if (eq? next '\,) ;;take care of a bizarre case:
	    (block
	      (input-next-token parser)
	      (let ((args (parse-matching-operator parser '\) )))
		`(,(sexpression-label parser op) () ,@args)))
	    (let ((match '\)))
	      (cond ((eq? match (next-token parser)) (input-next-token parser) nil)
		    (else
		     (iterate loop ((parse-tree-list `(,(parse-matching-binding parser '\,))) (colon? '#f))
		       (if (eq? match (next-token parser))
			   (block (input-next-token parser) 
				  `(,op ,@(make-binding parser (reverse parse-tree-list))))
			   (let ((next (input-next-token parser)))
			     (cond ((eq? '\, next)
				    (loop (cons (parse-matching-binding parser '\,) parse-tree-list) '#f))
				   ((and (eq? '\: next) (not colon?))
				    (loop `((\: ,(parse-matching-binding parser '\,))  ,@parse-tree-list) '#t))
				   (else (report-error parser (if colon?
								  "Expecting the character \",\"."
								  
								  "Expecting \":\" or \",\" or \")\"."))))))))))))))
						       

(define (MAKE-VAR-SPEC-LISTS-CONSISTENT une-liste)
  (let* ((bl (map (lambda (x) (cons (cadr x) (car x))) (cadr une-liste))))
    `(,(car une-liste)  ,bl ,@(cddr une-liste))))
	 
    
(define (PARSE-BINDING-OPERATOR-BOTH-SYNTAXES parser op)
  (make-var-spec-lists-consistent
   (parse-binding-operator-both-syntaxes-aux parser op)))

(define (MAKE-BINDING parser une-liste)
  (if (= (length une-liste) 1) (report-error parser "Bad Binding Body.")
      (iterate loop ((objects-so-far '()) (specs-so-far '()) (rem une-liste))
	(cond ((null? rem) (append (list (reverse! specs-so-far)) objects-so-far ))
	      ((and (list? (car rem))
		    (eq? (caar rem) '\:))
	       (if (null? objects-so-far)
		   (report-error parser "Bad binding syntax.")
		   (loop '() (cons (list (reverse! objects-so-far) (cadar rem)) specs-so-far) (cdr rem))))
	      (else (loop (cons (car rem) objects-so-far) specs-so-far (cdr rem)))))))


;;;(define (BUILD-CONDITIONAL parser op a-list)
;;;  (or (and (list? a-list) a-list)
;;;      (report-error parser "Missing alternative in conditional."))
;;;  (or (list? (car a-list))
;;;      (report-error parser "Non-list entry in conditional."))
;;;  (cond ((= (length (car a-list)) 1)
;;;	 (if (cdr a-list)
;;;	     (report-error parser "Dangling entries in conditional."))
;;;	 (caar a-list))
;;;	((= (length (car a-list)) 2)
;;;	`(,(sexpression-label parser op)
;;;	  ,(caar a-list)
;;;	  ,(cadar a-list)
;;;	  ,(build-conditional parser op (cdr a-list))))
;;;	(else (report-error parser "Two many entries in conditional."))))
;;;
;;;errors

(define (AMBIGUOUS-TOKEN-ERROR parser op)
  (report-error parser "Ambiguous token ~A encountered. Can mean: ~A"
		op
		(sexpression-label parser op)))

(define (ILLEGAL-LIST-ERROR parser)
  (report-error parser "Illegal list encountered."))

(define (ILLEGAL-TOKEN-ERROR parser op)
  (report-error parser "Illegal token ~A encountered." op))

(define (RIGHT-MATCH-ERROR parser op parse-tree)
  (ignore parse-tree)
  (report-error parser "Too many ~a." op))

(define (DELIMITER-ERROR parser op)
  (report-error parser "Illegal use of delimiter ~a." op))

(define (NO-SORT-ERROR parser)
  (report-error parser "No sort specified."))


(define PORT->IMPS-TOKENIZER (make-tokenizer-generator))

(walk (lambda (x) (make-significant-char-sequence port->imps-tokenizer x))
      '(** -> <= >= ^^ == ++ ))

(lset *parse* (make-parser))
(set (parser-tokenizer *parse*) port->imps-tokenizer)
	   
;;;order of arguments: parser external-format sexpression-label null-call-method left-call-method binding-power

(make-operator *parse* '\[ '() null-call-method-sb '() 200)
(make-operator *parse* '\] '() delimiter-error right-match-error 5)
(make-operator *parse* '\( '() null-call-method-lp left-call-method-lp 200)
(make-operator *parse* '\) '() delimiter-error right-match-error 5)

(make-operator *parse* '\{ 'left-french-bracket null-call-method-lfb left-call-method-lfb  200)
(make-operator *parse* '\} '() delimiter-error right-match-error 5)


;;;common operators:

(make-operator *parse* '+ '+ '() infix-operator-method 100)
(make-operator *parse* '++ '++ '() infix-operator-method 100)
;;;(make-operator *parse* '- '(- sub) negation-operator-method subtraction-operator-method
;;;	       '(110 111))
(make-operator *parse* '- '(- sub) negation-operator-method subtraction-operator-method
	       110)
(make-operator *parse* '* '* '() infix-operator-method 120)
(make-operator *parse* '** '** '() right-associative-infix-operator-method 121)
(make-operator *parse* '\/ '\/ '() infix-operator-method 121)

(make-operator *parse* '^ '^ '() right-associative-infix-operator-method 140)

(make-operator *parse* '^^ '^^ '() infix-operator-method 120)
(make-operator *parse* '! 'factorial '() postfix-operator-method 160)
(make-operator *parse* 'if 'if  parse-imps-cond '() 160)
;; formerly
;; (make-operator *parse* 'if 'if-term  parse-imps-cond '() 160)
(make-operator *parse* 'if_form 'if-form  parse-imps-cond '() 160)
(make-operator *parse* 'if_pred 'if  parse-imps-cond '() 160)
;; formerly
;; (make-operator *parse* 'if_pred 'if-pred  parse-imps-cond '() 160)



(make-operator *parse* 'form_cond 'if-form parse-imps-cond '() 160)
(make-operator *parse* 'cond 'if parse-imps-cond '() 160)
(make-operator *parse* 'term_cond 'if parse-imps-cond '() 160)
;; formerly
;; (make-operator *parse* 'term_cond 'if-term parse-imps-cond '() 160)
(make-operator *parse* 'pred_cond 'if parse-imps-cond '() 160)
;; formerly
;; (make-operator *parse* 'pred_cond 'if-pred parse-imps-cond '() 160)

(make-operator *parse* '\# '(is-defined is-defined-in-sort) defined-in-sort-prefix '() 160)
(make-operator *parse* '\' 'diff '() postfix-operator-method 160)
(make-operator *parse* '= '= '() infix-operator-method 80)
(make-operator *parse* '== '== '() infix-operator-method 80)
(make-operator *parse* '> '> '() infix-operator-method 80)
(make-operator *parse* '>= '>= '() infix-operator-method 80)
(make-operator *parse* '< '< '() infix-operator-method 80)
(make-operator *parse* '<= '<= '() infix-operator-method 80)
(make-operator *parse* 'not 'not loglike-operator-method '() 70)
(make-operator *parse* 'iff 'iff '() infix-operator-method 65)
(make-operator *parse* 'implies 'implies '() right-associative-infix-operator-method 59)
(make-operator *parse* 'and 'and prefix-operator-method nary-infix-operator-method 60)
(make-operator *parse* 'or 'or prefix-operator-method nary-infix-operator-method 50)
(make-operator *parse* '\, '() '() '() 10)

;;Another mad hack:
(make-operator *parse* '-> '() '() '() 10)

(make-operator *parse* '\: '() '() '() 10)

(make-operator *parse* 'forall 'forall parse-binding-operator-both-syntaxes '() 50)
(make-operator *parse* 'forsome 'forsome parse-binding-operator-both-syntaxes '() 50)
(make-operator *parse* 'iota 'iota parse-binding-operator-both-syntaxes '() 50)
(make-operator *parse* 'with 'with parse-binding-operator-both-syntaxes '() 50)
(make-operator *parse* 'lambda 'lambda parse-binding-operator-both-syntaxes '() 50)

(make-operator *parse* '\; '() null-call-method-terminator left-call-method-terminator -1)
(make-operator *parse* '? 'undefined loglike-operator-method  '() 180)

(make-operator *parse* 'falselike 'falselike prefix-operator-method '() 160)
(make-operator *parse* 'sub_p 'sub-predicate '() infix-operator-method 80)
(make-operator *parse* 'sub_f 'sub-function '() infix-operator-method 80)
(make-operator *parse* 'total_q 'total? prefix-sort-dependent-operator-method '() 160)
(make-operator *parse* 'nonvacuous_q 'nonvacuous? prefix-operator-method '() 160)

(make-operator *parse* 'reflexive_q 'reflexive? prefix-operator-method '() 160)
(make-operator *parse* 'transitive_q 'transitive? prefix-operator-method '() 160)
(make-operator *parse* 'antisymmetric_q 'antisymmetric? prefix-operator-method '() 160)
(make-operator *parse* 'comparable_q 'comparable? prefix-operator-method '() 160)
(make-operator *parse* 'well_founded_q 'well-founded? prefix-operator-method '() 160)
(make-operator *parse* 'partial_order_q 'partial-order? prefix-operator-method '() 160)
(make-operator *parse* 'linear_order_q 'linear-order? prefix-operator-method '() 160)
(make-operator *parse* 'upper_bound_q 'upper-bound? prefix-operator-method '() 160)
(make-operator *parse* 'chain_q 'chain? prefix-operator-method '() 160)
(make-operator *parse* 'cpo_q 'cpo? prefix-operator-method '() 160)
(make-operator *parse* 'monotone_q 'monotone? prefix-operator-method '() 160)
(make-operator *parse* 'continuous_q 'continuous? prefix-operator-method '() 160)

(make-operator *parse* 'sets '()  prefix-sort-operator-method '() 160)

(define *language-parser-table* (make-table '*language-parser-table*))

(define (language-parser language)
  (cond ((table-entry *language-parser-table* language))
	(else *parse*)))

(define (imps-string-read-proc language port)
  (let ((sexp (parse-top-level (language-parser language) port)))
    (if (use-old-apply-operator-form?)
	sexp
	(insert-apply-operators-in-sexp sexp))))

(set (imps-reader) imps-string-read-proc)

;;;(define (ITERATION-OPERATOR-METHOD parser op)
;;;  (if (not (eq? (next-token parser) '\())
;;;      (illegal-token-error parser (input-next-token parser)))
;;;  (input-next-token parser)
;;;  (let ((args (parse-matching-operator parser '\) )))
;;;    (if (= (length args) 3)
;;;	`(,(sexpression-label parser op) (lambda ,(car args)  ,(cadr args))
;;;					   (lambda ,(car args)  ,(caddr args)))
;;;	`(,(sexpression-label parser op) ,(car args) ,(cadr args)))))


;;;(define (build-expression-for-emacs pos str)
;;;  (let ((no (object-hash (qr str))))
;;;    (emacs-eval (format nil "(progn (set-buffer \"*IMPS Expression*\") (goto-char ~A) (insert \"\\n \\nimps-ref = ~A\"))" pos no))))

(define (build-expression-for-emacs pos str)
  (if (string-equal? str "")
      (imps-error "Null input; cursor not on formula.")
      (let ((obj (qr str)))
	(print-expression-for-emacs pos obj))))

(define (print-expression-for-emacs pos obj)
  (emacs-eval (format nil "(emacs-display-expression ~A ~S))"
		      pos
		      (format nil "~S" obj))))

(define (string->sort resolver str)
  (list->sort resolver (parse-top-level *parse* str)))

(define (string-or-list->sort resolver sorting-spec)
  (if (string? sorting-spec)
      (string->sort resolver sorting-spec)
      (list->sort resolver sorting-spec)))

(define (qr-safe str)
  (call-with-current-continuation
   (lambda (k) (bind (((imps-signal-error-procedure)
		       (lambda (error-type f-string f-args)
			 (ignore error-type)
			 (k (apply format nil (string-append "Syntax Error -- " f-string) f-args)))))
		 (qr str)))))


(define (qr-safe-reference str)
  (let ((expr-or-error-message (qr-safe str)))
    (if (expression? expr-or-error-message)
	(object-hash expr-or-error-message)
	expr-or-error-message)))
