;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald lisp-supplements)

; The test value that fails is 'FAIL

(define-integrable (FAIL? test-value)
  (eq? 'fail test-value))

(define-integrable (SUCCEED? test-value)
  (not (eq? 'fail test-value)))

(define-integrable (FAIL) 'fail)

(define-integrable (SUCCEED) '#t)

; the uncomputed value is %%uncomputed%%

(define-integrable (UNCOMPUTED? value)
  (eq? '%%uncomputed%% value))

(define-integrable (UNCOMPUTED) '%%uncomputed%%)

;;; If THE-LIST contains ELT, return the least n such that
;;; (nth the-list n) = elt -- otherwise '#f.
;;; 
(define (FIND-POSITION-IN-LIST the-list elt)
  (iterate iter ((the-list the-list)
		 (n 0))
    (cond ((null? the-list) '#f)
	  ((eq? elt (car the-list)) n)
	  (else (iter (cdr the-list) (1+ n))))))

(define (FIND-POSITIONS-IN-LIST the-list elts)
  (map (lambda (elt) (find-position-in-list the-list elt)) elts))


(define (any-such-that pred? list1)
  (iterate iter ((list1 list1))
    (cond ((null? list1) '#f)
	  ((pred? (car list1)) (car list1))
	  (else (iter (cdr list1))))))

(define (index-of-any the-list)
  (do ((i 0 (1+ i))
       (the-list the-list (cdr the-list)))
      ((or (null? the-list)
	   (car the-list))
       (and the-list i))))

(define (delete-1 obj the-list);;this may be essentially delete-set-element
  (iterate loop ((rem the-list) (head '()))
    (cond ((null? rem) the-list)
	  ((eq? (car rem) obj) (append (reverse! head) (cdr rem)))
	  (else (loop (cdr rem) (cons (car rem) head))))))

(define (REPLACE-NTH-IN-LIST! lst n new-value)
  (append! (first-n-cars lst n)
	   (cons new-value (nthcdr lst (1+ n)))))

(define (REPLACE-NTH-IN-LIST lst n new-value)
  (append (first-n-cars lst n)
	  (cons new-value (nthcdr lst (1+ n)))))

;; Given a list L, return two values, namely (last l) and a copy of l with ()
;; replacing the last cons cell in it.  If l is (), values are () and ().  If L
;; is (a), values are a and ().  

(define (last-&-all-but-last l)
  (cond ((null? l)
	 (return nil nil))
	((null? (cdr l))
	 (return (car l) nil))
	(else
	 (let ((l (copy-list l)))
	   (receive (last-val penultimate-cell)
	     (iterate iter ((current l) (next (cdr l)))
	       (if (null? (cdr next))
		   (return (car next) current)
		   (iter next (cdr next))))
	     (set (cdr penultimate-cell) nil)
	     (return last-val l))))))

(define (all-but-last l)
  (receive (() all-but)
    (last-&-all-but-last l)
    all-but))

(define (last-&-all-but-last! l)
  (cond ((null? l) (return '() '()))
	((null? (cdr l)) (return (car l) '()))
	(else
	 (iterate iter ((current l))
	   (if (null? (cddr current))
	       (let ((last (cadr current)))
		 (set (cdr current) '())
		 (return last l))
	       (iter (cdr current)))))))

(define (APPEND-ITEM-TO-END-OF-LIST elt l)
  (reverse (cons elt (reverse l))))

(define (APPEND-ITEM-TO-LAST-CDR! l new-last)
  (if (null? l)
      (list new-last)
      (let ((lc (lastcdr l)))
	(if (null? (cdr lc))
	    (set (cdr lc) (list new-last))
	    (error "append-item-to-last-cdr!:  Improper list ~S" l))
	l)))

(define (FIRST-N-CARS-&-REST lst n)
  (or (non-negative-integer? n)
      (error "FIRST-N-CARS-&-REST: N must be a non negative integer, not ~D." n))
  (iterate iter ((lst lst) (n n) (already nil))
    (cond ((zero? n) (return (reverse! already) lst))
	  ((null? lst)(error "FIRST-N-CARS-&-REST: list ~D too short." n))
	  (else
	   (iter (cdr lst)
		 (-1+ n)
		 (cons (car lst) already))))))

(define (FIRST-N-CARS lst n)
  (receive (front ())
    (first-n-cars-&-rest lst n)
    front))

(define (TREE-LAST-ATOM lst)
  (let ((l (last lst)))
    (if (atom? l)
	l
	(tree-last-atom l))))

(define (LEAVES lst)
  (iterate iter ((lst lst)(leaf-set nil))
    (cond ((null? lst) leaf-set)
	  ((atom? lst) (add-set-element lst leaf-set))
	  (else						;must be pair
	   (set-union
	    (iter (car lst) nil)
	    (iter (cdr lst) leaf-set))))))

(define (recursively-copy-list l)
  (if (pair? l)
      (cons (recursively-copy-list (car l))
	    (recursively-copy-list (cdr l)))
      l))

;;; A path is a list of fixnums, and indicates a path through a (0-based) tree,
;;; normally represented as a nested list.  Two paths diverge if they lead to
;;; nodes neither of which is in the portion of the tree rooted at the other.
;;; A list of paths is disjoint if they diverge pairwise.  

(define (PATHS-DIVERGE? path1 path2)
  (cond ((or (null? path1) (null? path2)) '#f)
	((= (car path1) (car path2))
	 (paths-diverge? (cdr path1) (cdr path2)))
	(else '#t)))

(define (PATH-DISJOINT-FROM-PATHS? path paths)
  (or (null? paths)
      (and (paths-diverge? path (car paths))
	   (path-disjoint-from-paths? path (cdr paths)))))

(define (PATHS-DISJOINT? paths)
  (everycdr?
   (lambda (l)
     (path-disjoint-from-paths? (car l)(cdr l)))
   paths))
    

; Given a long list LST, NEST-BELOW-MAXIMUM-NUMBER-OF-ARGUMENTS returns a
; nested list whose ultimate elements are the same as the elements of LST, such
; that no level of the nested list has more than *maximum-number-of-arguments*
; elements.  This is useful because APPLYhas such a low limit on the number of
; arguments it can take.

(define (NEST-BELOW-MAXIMUM-NUMBER-OF-ARGUMENTS lst . dont-copy)
  (let ((max (*value t-implementation-env '*maximum-number-of-arguments*))
	(lst (if dont-copy lst (copy-list lst)))
	(EXTRACT-CHUNK!
	 (lambda (lst len)
	   (let* ((chunk-end
		   (do ((i 1 (fx+ 1 i))
			(chunk-end lst (cdr chunk-end)))
		       ((or (fx>= i len)
			    (null? chunk-end))
			chunk-end)))
		  (rest (cdr chunk-end)))
	     (or (null? chunk-end)
		 (set (cdr chunk-end) nil))
	     (return lst rest)))))
    (iterate iter ((chunks '())
		   (rest lst))
      (if (null? rest)
	  (if (fx> (length chunks) max)
	      (nest-below-maximum-number-of-arguments chunks '#t)
	      chunks)
	  (receive (chunk rest)
	    (extract-chunk! rest max)
	    (iter (cons chunk chunks)
		  rest))))))

(define (APPLY-THROUGH-NESTED-LIST proc nested-list)
  (if (every? list? nested-list)			;really nested?
      (apply proc (map
		   (lambda (l)
		     (apply-through-nested-list proc l))
		   nested-list))
      (apply proc nested-list)))

(define (NEST-BELOW-MAXIMUM-AND-APPLY proc lst)
  (apply-through-nested-list
   proc
   (nest-below-maximum-number-of-arguments lst)))

; Non-destructively map through TREE, applying PROC at every (atomic) leaf.

(define (TREE-MAP proc tree)
  (if (atom? tree)
      (proc tree)
      (map
       (lambda (subtree)
	 (tree-map proc subtree))
       tree)))

;;; (WHICHEVER .  PROCS) returns a function which, applied to ARGS, returns
;;; first non-nil value of the form (proc . args), or nil if none.

(define (WHICHEVER . procs)
  (lambda args 
    (iterate iter ((procs procs))
      (and procs
	   (or (apply (car procs) args)
	       (iter (cdr procs)))))))
	


;;; Call each function in FN-LIST on ARG-LIST, and return a list of the results

(define (MAP-FNS fn-list arg-list)
  (iterate iter ((fn-list fn-list)
		 (result-list nil))
    (if (null? fn-list)
	(reverse! result-list)
	(iter (cdr fn-list)
	      (cons ((car fn-list) arg-list)
		    result-list)))))


;;; Check whether any value in a list is non-nil

(define (MAP-TRUE? lst)
  (cond ((null? lst) '#f)
	((true? (car lst)) '#t)
	(else
	 (map-true? (cdr lst)))))
      

;;; Call each function in FN-LIST on the corresponding member of ARG-LIST, and
;;; return a list of the results  
;;; 

(define (MAP-APPLICATION fn-list arg-list)
  (let ((ap (lambda (fn arg) (fn arg))))
    (map ap fn-list arg-list)))

(define (FLAT-MAP proc l)
  (apply append (map proc l)))

;;; return (MAP PROC LST) unless this would contain AVOID, in which case return that.

(define (MAP-BUT-AVOID proc lst avoid)
  (iterate iter ((lst lst)(so-far nil))
    (if (null? lst)
	(reverse! so-far)
	(let ((new-value (proc (car lst))))
	  (if (eq? avoid new-value)
	      avoid
	      (iter (cdr lst)
		    (cons new-value so-far)))))))

(define (any-pair? proc l1 l2)
  (do ((l1 l1 (cdr l1)))
      ((or (null? l1)
	   (any? (lambda (a2) (proc (car l1) a2)) l2))
       (not (null? l1)))))
       

(define (TRANSPOSE-MATRIX lists)
  (if (null? (car lists))
      nil
      (cons (map car lists)
	    (transpose-matrix (map cdr lists)))))

(define (list-ordering l1 l2)
  (iterate iter ((rest1 l1)
		 (rest2 l2))
    (cond ((null? rest1) '#t)
	  ((null? rest2) '#f)
	  ((< (car rest1)
	      (car rest2))
	   '#t)
	  ((< (car rest2)
	      (car rest1))
	   '#f)
	  (else 
	   (iter (cdr rest1)(cdr rest2))))))

(define (list-ordering-1 l1 l2)
  ;;This is similar to list ordering, but longer lists come first
  (iterate iter ((rest1 l1)
		 (rest2 l2))
    (cond ((null? rest2) '#t)
	  ((null? rest1) '#f)
	  ((< (car rest1)
	      (car rest2))
	   '#t)
	  ((< (car rest2)
	      (car rest1))
	   '#f)
	  (else 
	   (iter (cdr rest1)(cdr rest2))))))

(define (least-under-function function lst)
  (iterate iter ((champ (car lst))
		 (least (function (car lst)))
		 (rest (cdr lst)))
      (cond ((null? rest) champ)
	    ((let ((new (function (car rest))))
	       (and (fx< new least)
		    new))
	     =>
	     (lambda (new)
	       (iter (car rest) new (cdr rest))))
	    (else
	     (iter champ least (cdr rest))))))
	    
(define (least-under-descriptor-hash lst)
  (least-under-function descriptor-hash lst))

;;; (define NUMERICAL-OBJECT? (operation number?))
;;; (define NUMERICAL-= (operation =))
;;; (define NUMERICAL-+ (operation +))
;;; (define NUMERICAL-* (operation *))
;;; (define NUMERICAL-EXPT (operation expt))
;;; (define NUMERICAL-MINUS (operation -))
;;; (define NUMERICAL-=0? (operation =0?))
;;; (define NUMERICAL-=1? (operation (lambda (x) (= x 1))))
;;; (define NUMERICAL-> (operation >))


(define-integrable (SYMBOL-APPEND sym1 sym2)
  (concatenate-symbol sym1 sym2))

;;;  (string->symbol
;;;   (string-append
;;;    (symbol->string sym1)
;;;    (symbol->string sym2)))

(define (SEPARATED-STRING-APPEND separator strings)
  (if
   (null? strings) ""
   (let* ((sep-len (string-length separator))
	  (n (iterate sum-lengths ((strings (cdr strings))
				   (n (string-length (car strings))))
	       (if (null? strings)
		   n
		   (sum-lengths (cdr strings)
				(fx+ n
				     (fx+ sep-len (string-length (car strings))))))))
	  (replace-and-chdr!
	   (lambda (destination source)
	     (let ((source-len (string-length source)))
	       (nthchdr!
		(string-replace destination source source-len)
		source-len)))))
     (let* ((newstring (make-string n))
	    (dup (chopy newstring)))
       (iterate copying ((remn (replace-and-chdr! dup (car strings)))
			 (strings (cdr strings)))
	 (if (null? strings)
	     newstring
	     (copying
	      (replace-and-chdr!
	       (replace-and-chdr!
		remn
		separator)
	       (car strings))
	      (cdr strings))))))))


(define (substring-1? string1 string2)
  (let* ((len1 (string-length string1))
	 (first (char string1))
	 (test-substring
	  (lambda (string2)
	    (iterate iter2 ((i 0))
	      (cond ((fx= i len1) '#t)
		    ((char= (nthchar string1 i)
			    (nthchar string2 i))
		     (iter2 (fx+ i 1)))
		    (else '#f))))))
    (iterate iter ((string2 (copy-string string2))
		   (len2 (string-length string2)))
      (cond ((< len2 len1)  '#f)
	    ((= len1 len2)
	     (string-equal? string1 string2))
	    ((string-posq first string2)
	     =>
	     (lambda (j)
	       (let ((string2 (nthchdr! string2 j)))
		 (if (test-substring string2)
		     j
		     (iter (string-tail! string2)
			   (fx- len2 (fx+ j 1)))))))
	    (else '#f)))))

(define (substring? string1 string2)
  (let ((len1 (string-length string1))
	(len2 (string-length string2)))
    (and (not (fx< len2 len1))
	 (iterate iter ((i 0))
	   (cond ((fx= i len1) '#t)
		 ((char= (string-elt string1 i)
			 (string-elt string2 i))
		  (iter (fx+ i 1)))
		 (else '#f))))))
	

(define (STRING-LESS? string1 string2)
  (let* ((len1 (string-length string1))
	 (len2 (string-length string2))
	 (min-len (min len1 len2)))
    (do ((i 0 (fx+ i 1)))
	((or (fx= i min-len)
	     (not (char= (string-elt string1 i)
			 (string-elt string2 i))))
	 (if (fx= i min-len)
	     (< len1 len2)
	     (char< (string-elt string1 i)
		    (string-elt string2 i)))))))

(define (NON-NEGATIVE-INTEGER? n)
  (and (integer? n)
       (not-negative? n)))

(define (NEGATIVE-INTEGER? n)
  (and (integer? n)
       (negative? n)))

(define (ASS-L pred obj lst)
  (cond ((null? lst) nil)
	((pred obj (cdar lst)) (car lst))
	(else
	 (ass-l pred obj (cdr lst)))))

(define ASS-LQ
  (lambda (obj lst)
    (ass-l eq? obj lst)))
      

(define (ASS-VAL pred obj lst)
  (cond ((ass pred obj lst) => cdr)
	(else nil)))

(define (ASSQ-VAL obj lst)
  (cond ((assq obj lst) => cdr)
	(else nil)))

(define (HASH-< o1 o2)
  (let ((hash (*value t-implementation-env 'descriptor-hash)))
    (< (hash o1) (hash o2))))

(define (ASS-APPLY obj predicate-alist)
  (iterate iter ((alist predicate-alist))
    (cond ((null? alist) nil)
	  (((caar alist)
	    obj)
	   (car alist))
	  (else (iter (cdr alist))))))

(define (tree-hash tree)
  (cond ((pair? tree)
         (fixnum-abs
          (fx+ (tree-hash (car tree))
               (fixnum-ashl (tree-hash (cdr tree)) 1))))
        ((symbol? tree)
         ((*value t-implementation-env 'symbol-hash) tree))
        ((string? tree)
         ((*value t-implementation-env 'string-hash) tree))
        ((null? tree) 31415926)
        ((char? tree)
         (char->ascii tree))
        ((fixnum? tree)
         (fixnum-abs tree))
	((ratio? tree)
	 (fixnum-abs
	  (fx+ (fixnum-ashl (tree-hash (numerator tree)) 3)
	       (fixnum-ashl (tree-hash (denominator tree)) 1))))
	((flonum? tree)
	 (flonum->fixnum (* 1000000 x)))
	(else (descriptor-hash tree))))

(define (FLOATING-HASH x)
  (flonum->fixnum (* 1000000 x)))

(define (hash-combine-fixnums fixnums)
  (iterate iter ((result 0)
		 (fixnums fixnums)
		 (i 0))
    (if (null? fixnums)
	result
	(iter (fx+ result (fixnum-ashl (car fixnums) i))
	      (cdr fixnums)
	      (fx+ i 1)))))

(define (hash-combine-two-fixnums fx1 fx2)
  (fx+ fx1 (fixnum-ashl fx2 1)))

(define (reduce proc e l)
  (iterate iter ((val e)
		 (l l))
    (if (null? l)
	val
	(iter (proc val (car l))
	      (cdr l)))))

(define (reduce-map reducer e mapper l)
  (iterate iter ((val e)
		 (l l))
    (if (null? l)
	val
	(iter (reducer val (mapper (car l)))
	      (cdr l)))))

; A SETTABLE-ALIST is a settable operation that takes a key and retrieves the
; last value that it was set to for that key (NIL if there has been none).  The
; argument TYPE is a predicate enforced on all new values.

(define (SETTABLE-ALIST key-type value-type . warn-on-redefining?)
  (let ((alist nil))
    (operation 
	(lambda (key)
	  (cond ((assq key alist) => cdr)
		(else nil)))
      ((setter self)
       (lambda (key new-value)
	 (enforce key-type key)
	 (enforce value-type new-value)
	 (cond ((assq key alist)
		=>
		(lambda (entry)
		  (if (and key warn-on-redefining?)
		      (format '#t "~%; WARNING: redefining entry for ~S.~%" key))
		  (set (cdr entry) new-value)))
	       (else
		(set alist (cons (cons key new-value) alist)))))))))

; A SETTABLE-SYMBOL-ALIST is a settable-alist with symbols as its keys.

(define (SETTABLE-SYMBOL-ALIST value-type . warn?)
  (apply settable-alist symbol? value-type warn?))


;;;(define-structure-type N-D-TABLE
;;;  immediate-value
;;;  table)
;;;
;;;(set (n-d-table-immediate-value (stype-master n-d-table-stype)) nil) 
;;;
;;;(define (BUILD-N-D-TABLE)
;;;  (let ((ndt (make-n-d-table)))
;;;    (set (n-d-table-table ndt) (make-table))
;;;    ndt))
;;;
;;;(define N-D-TABLE-ENTRY
;;;  (operation
;;;      (lambda (ndt keys)
;;;	(if (null? keys)
;;;	    (n-d-table-immediate-value ndt)
;;;	    (let ((next-ndt (table-entry
;;;			     (n-d-table-table ndt)
;;;			     (car keys))))
;;;	      (and next-ndt
;;;		   (n-d-table-entry next-ndt (cdr keys))))))
;;;    ((setter self)
;;;     (lambda (ndt keys new-value)
;;;       (cond ((null? keys)
;;;	      (set (n-d-table-immediate-value ndt) new-value))
;;;	     ((table-entry (n-d-table-table ndt) (car keys))
;;;	      => (lambda (next-ndt)
;;;		   (set (n-d-table-entry next-ndt (cdr keys)) new-value)))
;;;	     (else
;;;	      (let ((next-ndt (build-n-d-table)))		
;;;		(set (table-entry (n-d-table-table ndt) (car keys))
;;;		     next-ndt)
;;;		(set (n-d-table-entry next-ndt (cdr keys)) new-value))))))))
 
(define TWO-D-TABLE-ENTRY
  (operation
      (lambda (table key1 key2)
 	(let ((subtable (table-entry table key1)))
 	  (and subtable
 	       (table-entry subtable key2))))
    ((setter self)
     (lambda (table key1 key2 new-value)
       (let ((subtable (table-entry table key1)))
 	 (if subtable
 	     (set (table-entry subtable key2) new-value)
 	     (block
 	       (set (table-entry table key1) (make-table))
 	       ((setter self) table key1 key2 new-value))))))))
 
(define (walk-two-d-table proc table)
  (walk-table
   (lambda (k1 table-1)
     (walk-table
      (lambda (k2 val)
 	(proc k1 k2 val))
      table-1))
   table))

(define make-two-d-table make-table)

(let ((symbol-hash
       (*value t-implementation-env 'symbol-hash)
       ;;
       ;; (lambda (sym) (string-hash (symbol->string sym)))
       ;; 
       ))

(define-operation (two-d-table-hash obj)
  (cond ((fixnum? obj) obj)
	((symbol? obj) (symbol-hash obj))
	(else
	 (symbol-hash
	  (concatenate-symbol obj)))))

)

(define (recursively-copy-table table id)
  (labels
      ((proc
	(lambda (o)
	  (cond (((*value t-implementation-env '%table?) o)
		 (recursively-copy-table
		  o
		  ((*value t-implementation-env '%table-id) o)))
		((%walkproof-table? o)
		 (recursively-copy-table
		  o
		  (%walkproof-table-id o)))
		(else o)))))

    (copy-table table id proc)))

(define (print-table table port)
  (walk-table
   (lambda (key entry)
     (format port "Key: ~s    Value: ~s~%"
	     key entry))
   table))

; This procedure prompts for an object.  The prompt is formatted from PROMPT
; and the FORMAT-ARGS.  It is printed on OUTPUT-PORT.  Then an sexp is read
; from INPUT-PORT and processed with PREPROCESSOR, if it is a function.  If
; TYPE is a procedure, it is applied to the resulting object--a false value
; causes a message to be printed and the process is repeated.

(define (RETRIEVE-OBJECT-FROM-USER
	 prompt input-port output-port . type-and-preprocessor-and-format-args)
  (destructure (((type preprocessor format-args) type-and-preprocessor-and-format-args))
    (iterate iter ()
      (apply format output-port (string-append "~%" prompt) format-args)
      (let ((obj
	     (if (procedure? preprocessor)
		 (preprocessor (read input-port))
		 (read input-port))))
	(if (or (not (procedure? type))
		(type obj))
	    obj
	    (block (format output-port "~&~A does not satisfy type predicate ~A." obj type)
		   (iter)))))))

(define (retrieve-y-or-n-from-user prompt . format-args)
  (retrieve-object-from-user
	      (string-append prompt "[y/n]: ")
	      (terminal-input)(terminal-output)
	      (object boolean? 
		  ((print self port)
		   (print 'y-or-n? port)))
	      (lambda (sym)
		(cond ((eq? 'y  sym) '#t)
		      ((eq? 'yes  sym) '#t)
		      ((eq? 'n  sym) '#f)
		      ((eq? 'no  sym) '#f)
		      (else sym)))
	      format-args))
  

(define (export-fn env vars vals)
  (do ((vars vars (cdr vars))
       (vals vals (cdr vals)))
      ((null? vars))
    (*define env (car vars) (car vals))))

(define-syntax (export env . vars)
  `(export-fn
    ,env ',vars
    (map (lambda (v) (eval v (the-environment)))
	 ',vars))) 

(define (SORT-PATHS paths)
  (let ((sort-list (*value t-implementation-env 'sort-list)))
    (sort-list paths list-ordering)))
    
(define (SORT-PATHS! paths)
  (let ((sort-list! (*value t-implementation-env 'sort-list!)))
    (sort-list! paths list-ordering)))


(define (SORT-PATHS-1! paths)
  (let ((sort-list! (*value t-implementation-env 'sort-list!)))
    (sort-list! paths list-ordering-1)))

(define (EXTRACT-DISJOINT-PATHS paths)
  (iterate loop ((paths (sort-paths! paths)) (accum '()))
    (cond ((null? paths) (reverse! accum))
	  ((null? (cdr paths)) (reverse! (cons (car paths) accum)))
	  ((path-extends? (car paths) (cadr paths))
	   (loop (cdr paths) accum))
	  (else (loop (cdr paths) (cons (car paths) accum))))))
	
(define (EXTRACT-MINIMAL-DISJOINT-PATHS paths)
  (iterate loop ((paths (sort-paths! paths)) (accum '()))
    (cond ((null? paths) (reverse! accum))
	  ((null? (cdr paths)) (reverse! (cons (car paths) accum)))
	  ((path-extends? (car paths) (cadr paths))
	   (loop (cons (car paths) (cddr paths)) accum))
	  (else (loop (cdr paths) (cons (car paths) accum))))))

(define (PATH-EXTENDS? path1 path2)
  (cond ((null? path1) '#t)
	((null? path2) '#f)
	((= (car path1) (car path2))
	 (path-extends? (cdr path1) (cdr path2)))
	(else '#f)))

(define (REMOVE-DUPLICATES predicate une-liste)
  (remove-duplicates-front-to-back predicate une-liste))

(define (REMOVE-DUPLICATES-FRONT-TO-BACK predicate une-liste)
  (iterate loop ((une-liste une-liste) (accum '()))
    (cond ((null? une-liste) (reverse! accum))
	  ((mem? predicate (car une-liste) (cdr  une-liste))
	   (loop (cdr une-liste) accum))
	  (else (loop (cdr une-liste) (cons (car une-liste) accum)))))) 

(define (REMOVE-DUPLICATES-BACK-TO-FRONT predicate une-liste)
  (iterate loop ((une-liste (reverse une-liste)) (accum '()))
    (cond ((null? une-liste) accum)
	  ((mem? predicate (car une-liste) (cdr  une-liste))
	   (loop (cdr une-liste) accum))
	  (else (loop (cdr une-liste) (cons (car une-liste) accum)))))) 

(define (TRUE-ASSOCIATION-LIST? arg)
  (and (list? arg)
       (or (null? arg)
	   (let ((entry (car arg)))
	     (and (pair? arg)
		  (not (assq (car entry) (cdr arg)))
		  (true-association-list? (cdr arg)))))))

(define (REPLACE-NTH lst n replacement)
  (let ((first-n (reverse 
		    (nthcdr 
		     (reverse lst) 
		     (subtract (length lst) n)))))
    (append first-n (cons replacement (nthcdr lst (add1 n))))))
    
(define (BIG-PRODUCT lists)
  (if (null? lists) '(())
      (let ((p1 (car lists))
	    (p2 (big-product (cdr lists))))
	(apply append
	       (map
		(lambda (a)
		  (map (lambda (l) (cons a l))
		       p2))
		p1)))))


(define (REPLACE-LIST-ENTRIES the-list replacement)
  (map (lambda (x) (ignore x) replacement) the-list))

(define (CHOOSE-LIST-ENTRIES the-list occurrences)
  (let ((len (length the-list)))
    (map
     (lambda (n)
       (or (< n len)
	   (imps-error "CHOOSE-LIST-ENTRIES: index too large."))
       (nth the-list n))
     occurrences)))

(define (LIST-DIFFERENCE list1 list2 predicate)
  (iterate loop ((accum '())
		 (rem list1))
    (cond ((null? rem) accum)
	  ((mem? predicate (car rem) list2)
	   (loop accum (cdr rem)))
	  (else
	   (loop (cons (car rem) accum)
		 (cdr rem))))))


(define-predicate ANONYMOUS-NAME?)

(define MAKE-ANONYMOUS-NAME
  (let ((n 0))
    (lambda d
      (let ((index n))
	(let ((sym (object nil
		     ((anonymous-name? soi) '#t)
		     ((print soi port) (map (lambda (x) (format port "~A" x)) d)
				       (format port "~A" index)))))
					 
	  (set n (1+ n))
	  sym)))))


(define (ALTERNATE-INSERT separator the-list)
  (if (null? the-list) the-list
      (iterate loop
	  ((rest (cdr the-list)) (collect (list (car the-list))))
	(if (null? rest) (reverse! collect)
	    (loop (cdr rest) `(,(car rest) ,separator ,@collect))))))

(define (MAP-ALTERNATE-INSERT separator proc the-list)
  (if (null? the-list) the-list
      (iterate loop
	  ((rest (cdr the-list)) (collect (list (proc (car the-list)))))
	(if (null? rest) (reverse! collect)
	    (loop (cdr rest) (cons (proc (car rest)) (cons separator collect)))))))

(define (retrieve-unused-name proc . name-components)
  (let ((try (apply concatenate-symbol name-components)))
    (if (proc try)
	  (iterate loop ((n 0))
	    (let ((tryn (concatenate-symbol try '_ n)))
	      (if (proc tryn)
		  (loop (1+ n))
		  tryn)))
	try)))


(define (filter-list filter? la-liste)
  (iterate loop ((la-liste la-liste) (accum '()))
    (cond ((null? la-liste) (reverse! accum))
	  ((filter? (car la-liste))
	   (loop (cdr la-liste)
		 (cons (car la-liste) accum)))
	  (else
	   (loop (cdr la-liste) accum)))))

(define (MAPQUOTE l)
  (map (lambda (x) (list 'quote x)) l))


