;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald mitlib)

;;; from the MIT /math/vector library.
;;; 7-3-89

(define (matrix? m)
  (and (vector? m)
       (vector? (vref m 0))))

(define (make-matrix n m . optional)
  (let ((ans (make-vector n))
	(filler (if optional (car optional) '())))
    (iterate loop ((i 0))
	     (if (= i n)
		 ans
		 (block (vset ans i
				    (make-vector m filler))
			(loop (+ i 1)))))))

(define (generate-matrix rows cols proc)
  (let ((ans (make-matrix rows cols)))
    (iterate loop-rows ((i 0))
	     (if (= i rows)
		 ans
		 (block (iterate loop-columns ((j 0))
			  (if (= j cols)
			      'done
			      (block (matrix-set ans i j (proc i j))
				     (loop-columns (+ j 1)))))
			(loop-rows (+ i 1)))))))

(define (generate-vector n proc)
  (let ((ans (make-vector n)))
    (iterate loop ((i 0))
	     (if (= i n)
		 ans
		 (block (vset ans i (proc i))
			(loop (1+ i)))))))

(define (matrix-by-rows r1 . rest)
  (let* ((len (length rest))
	 (mat (make-vector (1+ len) 0)))
    (vset mat 0 r1)
    (iterate loop ((n 1) (rest rest))
	     (if (<= n len)
		 (block (vset mat n (car rest))
			(loop (1+ n) (cdr rest)))
		 mat))))

(define (num-rows m) (vector-length m))
(define (num-cols m) (vector-length (vref m 0)))

(define (matrix-ref m i j)
  (vref (vref m i) j))
(define mref matrix-ref)
(define (matrix-set m i j v)
  (vset (vref m i) j v))
(define mset matrix-set)

(define (nth-row M n)
  (vref M n))
(define (nth-col M n)
  (nth-row (transpose M) n))

(define (transpose m)
  (generate-matrix (num-cols m)
		   (num-rows m)
		   (lambda (i j) (matrix-ref m j i))))




;;; Following are not from the MIT library.

;;; OTHER USEFUL TOOLS:
;;; dpr 8-24-89

(define (generate-list n proc)
  (iterate loop ((i (-1+ n)) (ans '()))
    (if (>= i 0)
	(loop (-1+ i) (cons (proc i) ans))
	ans)))

(define (identity-matrix n)
  (generate-matrix n n (lambda (i j) (if (= i j) 1 0))))

(define (list-ref list index)
  (if (= index 0)
      (car list)
      (list-ref (cdr list) (-1+ index))))

(define (list-delete list index)
  (if (= index 0)
      (cdr list)
      (cons (car list) (list-delete (cdr list) (-1+ index)))))

(define (list-replace list index object)
  (if (= index 0)
      (cons object (cdr list))
      (cons (car list) (list-replace (cdr list) (-1+ index) object))))


(define (vcopy v) ;returns identical copy of vector: equal? but not eq?
  (generate-vector (vector-length v)
		   (lambda (i) (vref v i))))

(define (mcopy m)
  (generate-matrix (num-rows m) (num-cols m)
		   (lambda (i j) (mref m i j))))

(define (vneg v)  ;returns negation of a vector
  (generate-vector (vector-length v) (lambda (i) (- (vref v i)))))

(define (unit-vector? v)
  (iterate loop ((index (-1+ (vector-length v)))
		 (found-1? '()))
	   (if (>= index 0)
	       (cond ((= (vref v index) 1)
		      (if found-1?
			  '()
			  (loop (-1+ index) index)))
		     ((= (vref v index) 0)
		      (loop (-1+ index) found-1?))
		     (else '()))
	       found-1?)))

;;; NEGATE-ROW returns matrix with row i negated. (0-based)

(define (negate-row matrix index)
  (generate-vector (num-rows matrix)
		   (lambda (i) (if (= i index)
				   (negate-vector (nth-row matrix i))
				   (nth-row matrix i)))))

;;; NEGATE-ROW returns same, but mutates data.

(define (negate-row! matrix index)
  (vset matrix index (vneg (vref matrix index)))
  matrix)

(define (negate-elm vector index)
  (generate-vector (vector-length vector)
		   (lambda (i) (if (= i index)
				   (- (vref vector i))
				   (vref vector i)))))

;;;ZERO-ROW! makes the index-th row of A all zero.

(define (zero-row! A index)
  (vset A index (make-vector (num-cols A) 0)))
(define (zero-elm! B index)
  (vset B index 0))

(define (zero-vector? v)
  (and (vector? v)
       (iterate loop ((i (-1+ (vector-length v))))
		(if (= (vref v i) 0)
		    (if (> i 0)
			(loop (-1+ i))
			t)
		    '()))))

;;; LIST-APPEND! appends L2 onto L1 and then returns L1.

(define (list-append! L2 L1)
  (if (cdr L1)
      (list-append L2 (cdr L1))
      (set (cdr L1) L2))
  L1)

(define (negate-matrix matrix) ;non-mutating
  (generate-matrix (num-rows matrix)
		   (num-cols matrix)
		   (lambda (i j)
		     (- (mref matrix i j)))))

(define (negate-vector vector) ;non-mutating
  (generate-vector (vector-length vector) (lambda (i) (- (vref vector i)))))

(define (vector-all-non-pos? vector)
  (iterate loop ((i (-1+ (vector-length vector))))
    (if (>= i 0)
	(if (<= (vref vector i) 0)
	    (loop (-1+ i))
	    '#f)
	'#t)))

;;; VECTOR-SUBSET returns a vector whose 0th element is the start-th
;;; element of VECTOR and whose last element is the end-th element.

(define (vector-subset vector start end)
    (generate-vector (1+ (- end start))
		     (lambda (i)
		       (vref vector (+ i start)))))

;;; FIND-MINIMUM-NON-NEG returns the index of the least non negative
;;; element of vector, ties settled arbitrarily.

(define (find-least-non-neg vector)
  (let ((greatest (largest-non-neg-value vector)))
    (if (eq? greatest 'all-neg)
	'all-neg
	(iterate loop ((index (-1+ (vector-length vector)))
		       (j 'none) (least greatest))
	  (if (>= index 0)
	      (let ((val (vref vector index)))
		(if (and (<= val least)
			 (>= val 0))
		    (loop (-1+ index) index val)
		    (loop (-1+ index) j least)))
	      j)))))

(define (largest-non-neg-value vector)
  (iterate loop ((index (-1+ (vector-length vector)))
		 (largest -1))
    (if (>= index 0)
	(loop (-1+ index) (larger (vref vector index) largest))
	(if (>= largest 0)
	    largest
	    'all-neg))))

(define (larger a b)
  (if (> a b) a b))

;;; MEMQN does the same thing as MEMQ?, but instead of returning #T it
;;; returns the index (Number) of the element in question.

(define (memqn p Lst)
  (iterate loop ((i 0) (rest Lst))
    (if rest
	(if (eq? p (car rest))
	    i
	    (loop (1+ i) (cdr rest)))
	'#f)))

;;; LIST-SUBSET determines if all of the elements of LS1 are also in LS2

(define (list-subset? LS1 LS2)
  (if (not LS1)
      t
      (if (memq (car LS1) LS2)
	  (if (cadr LS1)
	      (list-subset? (cdr LS1) LS2)
	      t)
	  '())))
  
;;; PAIR-ELEMENTS returns a list of lists (LS1[n] LS2[n])

(define (pair-elements LS1 LS2)
  (let ((longer (if (> (length LS2) (length LS1)) LS2 LS1)))
    (cond ((not (car longer))
	   '())
	  ((cadr longer)
	   (cons (list (car LS1) (car LS2))
		 (pair-elements (cdr LS1) (cdr LS2))))
	  (else (list (list (car LS1) (car LS2)))))))


;;; VECTOR-COMPONENTS-SUM returns the sum of the elements of V.

(define (vector-components-sum v)
  (let ((len (vector-length v)))
    (iterate loop ((i (-1+ len)) (sum 0))
      (if (>= i 0)
	  (loop (-1+ i) (+ sum (vref v i)))
	  sum))))


(define (vector-sub v1 v2)
  (if (= (vector-length v1) (vector-length v2))
      (generate-vector (vector-length v1)
		       (lambda (i) (- (vref v1 i) (vref v2 i))))
      (error "Different size vectors to vector-sub")))

;;Added by jt.

(define (VECTOR-APPEND . vectors)
  (list->vector (apply append (map! vector->list vectors))))

(define (MATRIX-APPEND . matrices)
  (if (null? matrices) (error "MATRIX APPEND: needs at least one matrix to append"))
  (let* ((n (vector-length (car matrices)))
	 (new-matrix (make-vector n)))
    (iterate loop ((i 0))
      (if (< i n)
	  (block
	    (set (vref new-matrix i)
		 (apply vector-append (map (lambda (x) (vref x i)) matrices)))
	    (loop (1+ i)))
	  new-matrix))))

  
  
