;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SORT-SUBSTITUTION)



;;; SUBSTITUTION STRUCTURE TYPE

(define (EXPRESSION-SUBSTITUTE-SORTS sort-alist expression)
  (if (and (succeed? sort-alist)
	   (expression? expression)
	   (not (expression-var-name-conflict? expression)))
      (cond ((variable? expression)
	     (variable-substitute-sorts sort-alist expression))
	    ((constant? expression) expression)
	    ((null? (expression-components expression))
	     expression)
	    ((not (binding-expression? expression))
	     (let* ((constr (expression-constructor expression))
		    (comps (expression-components expression))
		    (comp-substitutions (map
					(lambda (comp)
					  (expression-substitute-sorts sort-alist comp))
					comps)))
	       (if (every? expression? comp-substitutions)
		   (apply constr comp-substitutions)
		   (fail))))
	    (else
	     (let ((constr (expression-constructor expression))
		   (body (expression-substitute-sorts sort-alist (binding-body expression)))
		   (vars (variable-list-substitute-sorts 
			  sort-alist 
			  (binding-variables expression))))
	       (if (and (not (fail? vars)) (expression? body))
		   (apply constr body vars)
		   (fail)))))
      (fail)))

(define (VARIABLE-SUBSTITUTE-SORTS sort-alist variable)
  (let ((sort (sort-substitute-sort sort-alist (expression-sorting variable))))
    (if (sort? sort)
	(find-variable (name variable) sort)
	(fail))))

(define (VARIABLE-LIST-SUBSTITUTE-SORTS sort-alist variables)
  (catch stop
    (map
     (lambda (var)
       (let ((var1 (variable-substitute-sorts sort-alist var)))
	 (if (expression? var1) var1 (stop (fail)))))
     variables)))

(define (SORT-SUBSTITUTE-SORT sort-alist sort)
  (if (and (succeed? sort-alist) (sort? sort))
      (cond ((assq sort sort-alist)
	     =>
	     cdr)
	    ((and (base-sort? sort)
		  (sort-is-type? sort))
	     sort)
	    ((name sort)		; SORT is a resolved sort
	     (fail))
	    (else			
	     (let ((domains (map
			     (lambda (domain)
			       (sort-substitute-sort sort-alist domain))
			     (higher-sort-domains sort)))
		   (range (sort-substitute-sort sort-alist (higher-sort-range sort))))
	       (if (and (every? sort? domains)
			(sort? range))
		   (build-maximal-higher-sort domains range)
		   (fail)))))
      (fail)))

(define (SCHEMATIC-MATCH expr pattern fixed-sorts)
  (let ((sort-alist
	 (variable-sorts-match pattern expr fixed-sorts)))
    (if (fail? sort-alist)
	(return (fail) (fail))
	(let* ((trans-pattern (expression-substitute-sorts sort-alist pattern))
	       (subst (if (succeed? trans-pattern)
			  (match expr trans-pattern)
			  (fail))))
	  (if (succeed? subst) 
	      (return sort-alist subst)
	      (return (fail) (fail)))))))

(define (APPLY-SCHEMATIC-SUBSTITUTION sort-alist subst expression)
  (let ((translated-expression (expression-substitute-sorts sort-alist expression)))
    (if (expression? translated-expression)
	(apply-substitution-fastidiously subst translated-expression)
	(fail))))
