;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994

(herald interval-partitions)

;;In this file we study division of the interval [a,b] into
;;equally-spaced partition points a<delta*n, delta*(n+1) ,...,
;;delta*m<=b

;;Let n=floor(a/delta), m = floor(b/delta). Then 
;; (a) n*delta <= a < (n+1)*delta and m*delta <= b <(m+1)*delta


(def-translation commutative-monoid-theory-to-uu
   force-under-quick-load
   (source commutative-monoid-theory)
  (target VECTOR-SPACES-OVER-RR)
  (fixed-theories h-o-real-arithmetic)
  (sort-pairs (uu uu))
  (constant-pairs
   (e v0)
   (** ++)
   )
  (theory-interpretation-check using-simplification))

(def-renamer monoid-to-uu-renamer
  (pairs 
   (monoid%prod uu%sum)))

(def-transported-symbols monoid%prod
  (translation commutative-monoid-theory-to-uu)
  (renamer monoid-to-uu-renamer))

(def-overloading sum (h-o-real-arithmetic sum) (vector-spaces-over-rr uu%sum))

(def-theorem interval-partititions
  "forall(s:[zz,uu], a:ii, 
           deriv(lambda(x:ii,sum(1+floor(a/delta),floor(x/delta),lambda(j:zz,delta*s(j)))+
                          delta*(x-dseq(delta)(x))))=s(floor(x/delta)))


