;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald MACETES)


(define-predicate MACETE?)
(define-settable-operation (MACETE-NAME soi))
;;(define-operation (MACETE-ALIASES soi))

; A macete has a name which can be a symbol or '().
; The name can be changed only if non-nil.

;;(lset *OTHER-MACETE-TABLE* (make-table '*OTHER-MACETE-TABLE*))
;;(lset *SAFE-ELEMENTARY-MACETE-TABLE* (make-table '*SAFE-ELEMENTARY-MACETE-TABLE*))

(lset *MACETE-TABLE* (make-table '*MACETE-TABLE*))

(define (COUNT-MACETES)
  (let ((count 0))
    (walk-table
     (lambda (key entry)
       (ignore key entry)
       (increment count))
     *MACETE-TABLE*)
    count))

(define (NAME->MACETE the-name)
  (if (raise-name-error?)
      (or (table-entry *macete-table* the-name)
	  (imps-error "NAME->MACETE: ~A is not the name of a macete." the-name))
      (table-entry *macete-table* the-name)))

(define-operation (APPLY-MACETE soi context expr . dont-print?)
  (imps-enforce macete? soi)
  (return context expr))

; A macete *succeeds* on expr iff one of the returned context and  expression are different from context or expr.
; otherwise the macete *fails*. By default, macetes fail.

(define-settable-operation (MACETE-DOCUMENTATION-STRING soi))

(define-operation (BIDIRECTIONAL-MACETE? macete)
  (imps-enforce macete? macete) '#t)

;A macete SOI is bidirectional means that (apply-macete soi context expr) has
;the same meaning as expr if the macete is sound. By default macetes are bidirectional.
;The other possibility we consider are backchaining macetes. If expr is a formula,
;and soi is a backchaining macete, then (apply-macete soi context expr) implies expr.

(define-operation (MACETE-SOUND-IN-THEORY? macete THEORY)
  (imps-enforce macete? macete) '#f) ;for now

(define (INTERACTIVE-MACETE? soi)
  (imps-enforce macete? soi)
  (true? (macete-name soi)))

;;;(define-operation (MAKE-INTERACTIVE macete))

;;Theorem macetes are special kinds of macetes associated with pattern matching.
;;(See files elementary-macetes and transportable-macetes)
 
;A macete is sound means that it is mathematically sound.
;BY DEFAULT MACETES ARE UNSOUND. Some justification is necessary to make a macete sound.
;This can be done in a number of ways.
;Unsound macetes are useful in exploratory reasoning. 
;Clearly,  the soundness of a macete is theory dependent.

;Messages to provide some feedback to user :

(lset *message-begin*
      (lambda (mac context expr)
	(if (not (composite-macete? mac))
	    (format t "~&Context#: ~D ~15TExpression#: ~D ~35TMacete: ~A ... "
		    (object-hash context) (object-hash expr) (name mac)))))
;;; 
;;;                   "~&Applying macete ~a to context #~D and expression #~D... "
;;; 		    mac (object-hash context) (object-hash expr)

(lset *message-end* (lambda (mac)
		      (if (not (composite-macete? mac))
			  (format t "done."))))

(define (BUILD-MACETE proc bidirectional? the-name)

  ;;proc should be nil or a procedure of arguments: CONTEXT, EXPRESSION
  ;;which returns an EXPRESSION

  (or (null? the-name) (symbol? the-name) (imps-error "Invalid name: ~a" the-name))
  (let ((doc-str "Not documented")
	(name-list (list the-name)))
    (object nil
      ((apply-macete soi context expr)
       (*message-begin* soi context expr)
       (let ((new-expr (proc context expr)))
	 (*message-end* soi)
	 ;;(if (and bidirectional?
	 ;;		  (not (eq? new-expr expr))
	 ;;		  (null? undischarged-minor-premises)
	 ;;		  (macete-sound-in-theory? soi (context-theory context)))
	 ;;	     (add-context-entry context
	 ;;				(quasi-equality expr new-expr)))
	 new-expr))
      ((name soi) (car name-list))
      ((macete-name soi) (car name-list))
      ((bidirectional-macete? soi) bidirectional?)
      (((setter macete-name) soi new-name)
       (if (symbol? new-name)
	   (or (eq? new-name (car name-list))
	   (set name-list (cons new-name name-list)))))
;;;  
;;;       (if (and the-name (not (eq? (car name-list) new-name)))
;;;	   ;;Name change: existing name is non-trivial and different from the proposed name
;;;	   (imps-warning "Changing name of macete ~a to ~a.~%" the-name new-name))
;;;  
  
;;;   ((macete-aliases soi) name-list)
      ((macete? soi) '#t)

      ((macete-documentation-string soi) doc-str)
      (((setter macete-documentation-string) soi str)
       (set doc-str str))
      
      ((print soi port)
       (format port "#{Macete ~A: ~A}" (object-hash soi) (macete-name soi))))))

(define (macete->sexp macete)
  (cond ((elementary-macete? macete)
	 (list (name macete)
	       (qp (elementary-macete->formula macete))))
	((composite-macete? macete)
	 (cons (macete-constructor-name macete)
	       (map macete->sexp (macete-components macete))))
	(else (list (name macete)
		    (macete-documentation-string macete)))))

;;;(define (APPLY-MACETE-RULE macete)
;;;  (labels
;;;      ((rule
;;;	(object
;;;	    (lambda (sequents)
;;;
;;;	      (let* ((major-premise (if (null? (cdr sequents))
;;;					nil
;;;					(car sequents)))
;;;		     (conclusion (last sequents))
;;;		     (assertion (sequent-assertion conclusion))
;;;		     (context (sequent-context conclusion)))
;;;		(if (not (null? (cddr sequents)))
;;;		    (imps-error "make-backchaining-rule: too many hypotheses ~S"
;;;				(reverse (cdr (reverse sequents)))))
;;;		(let ((hypothesis-assertion
;;;		       (apply-macete macete context assertion)))
;;;		  (cond ((eq? hypothesis-assertion assertion)
;;;			 (fail))
;;;			((truth? hypothesis-assertion)
;;;			 (build-inference rule
;;;					  nil
;;;					  conclusion))
;;;			((and (not (null? major-premise))
;;;			      (sequent-entails-sequent?
;;;			       major-premise
;;;			       (build-sequent context hypothesis-assertion)))
;;;			 (build-inference rule
;;;					  (list major-premise)
;;;					  conclusion))
;;;			((not (null? major-premise)) (fail))
;;;			(else
;;;			 (build-inference rule
;;;					  (list
;;;					   (build-sequent
;;;					    context
;;;					    hypothesis-assertion))
;;;					  conclusion))))))
;;;    	  ((rule? r) '#t)
;;;	  ((rule-soundness-predicate self)
;;;	   (lambda (theory)
;;;	     (macete-sound-in-theory? macete theory)))
;;;	  ((rule-generator r) macete)
;;;	  ((name r) (name macete))
;;;	  ((print soi port)
;;;	   (format port "#{Backchaining Macete ~a}" (name macete))))))
;;;
;;;    rule))

(define (MACETE-AT-PATHS-RULE-GENERATOR macete paths)
  (labels
      ((rule
	(object
	    (lambda (sequents)

	      (let* ((major-premise (if (null? (cdr sequents))
					nil
					(car sequents)))
		     (conclusion (last sequents))
		     (assertion (sequent-assertion conclusion))
		     (context (sequent-context conclusion)))
		(if (not (null? (cddr sequents)))
		    (imps-error "MACETE-AT-PATHS-RULE-GENERATOR: too many hypotheses ~S"
				(reverse (cdr (reverse sequents)))))
		(let ((hypothesis-assertion 
		       (apply-procedure-at-paths
			(lambda (theory context expr)
			  (ignore theory)
			  (return (apply-macete macete context expr) '()))
			context
			assertion
			paths
			(bidirectional-macete? macete))))
		  (cond ((eq? hypothesis-assertion assertion)
			 (fail))
			((truth? hypothesis-assertion)
			 (build-inference rule
					  nil
					  conclusion))
			((and (not (null? major-premise))
			      (sequent-entails-sequent?
			       major-premise
			       (build-sequent context hypothesis-assertion)))
			 (build-inference rule
					  (list major-premise)
					  conclusion))
			((not (null? major-premise)) (fail))
			(else
			 (build-inference rule
					  (list
					   (build-sequent
					    context
					    hypothesis-assertion))
					  conclusion))))))
    	  ((rule? r) '#t)
	  ((rule-soundness-predicate self)
	   (lambda (theory)
	     (macete-sound-in-theory? macete theory)))
	  ((rule-generator r) macete)
	  ((name r) (name macete))
	  ((print soi port)
	   (format port "#{Macete at path ~a}" (name macete))))))

    rule))

(define (MACETE-AT-PATHS-WITH-MINOR-PREMISES-RULE-GENERATOR macete paths)
  (labels
      ((rule
	(object
	    (lambda (sequents)

	      (let* ((major-premise (if (null? (cdr sequents))
					nil
					(car sequents)))
		     (conclusion (last sequents))
		     (assertion (sequent-assertion conclusion))
		     (context (sequent-context conclusion)))
		(if (not (null? (cddr sequents)))
		    (imps-error "MACETE-AT-PATHS-WITH-MINOR-PREMISES-RULE-GENERATOR: too many hypotheses ~S"
				(reverse (cdr (reverse sequents)))))
		(receive (hypothesis-assertion minors)
		  (run-proc-with-minor-premises
		   (lambda ()
		     (apply-procedure-at-paths
		      (lambda (theory context expr)
			(ignore theory)
			(return (apply-macete macete context expr) '()))
		      context
		      assertion
		      paths
		      (bidirectional-macete? macete))))
		  (cond ((eq? hypothesis-assertion assertion)
			 (fail))
			((truth? hypothesis-assertion)
			 (build-inference rule
					  minors
					  conclusion))
			((and (not (null? major-premise))
			      (sequent-entails-sequent?
			       major-premise
			       (build-sequent context hypothesis-assertion)))
			 (build-inference rule
					  (cons major-premise minors)
					  conclusion))
			((not (null? major-premise)) (fail))
			(else
			 (build-inference rule
					  (cons
					   (build-sequent
					    context
					    hypothesis-assertion) minors)
					  conclusion))))))
    	  ((rule? r) '#t)
	  ((rule-soundness-predicate self)
	   (lambda (theory)
	     (macete-sound-in-theory? macete theory)))
	  ((rule-generator r) macete)
	  ((name r) (name macete))
	  ((print soi port)
	   (format port "#{Macete at path ~a}" (name macete))))))

    rule))

;;;(define (THEORY-ADD-MACETE theory macete)
;;;  (ignore theory)
;;;  (ADD-MACETE macete)) ; Obsolete
 
;;;(define (THEORY-GET-MACETE theory the-name)
;;; (ignore theory)
;;; (GET-MACETE the-name)) ; Obsolete

(define (COMPOUND-OR-ODDBALL-MACETE? macete)
  (and (macete? macete)
       (not (safe-elementary-macete? macete))))

(define (ADD-MACETE macete) 
  (imps-enforce macete? macete)
  (if (macete-name macete)
      (block
	(if (not (table-entry *macete-table* (macete-name macete)))
	    (insert-macete-key macete))
	(set (table-entry *macete-table* (macete-name macete)) macete)))
  macete)

(define (apply-macete-without-minor-premises macete context expr)
  (bind (((accumulate-undischarged-minor-premises?) '#f)
	 (undischarged-minor-premises '()))
    (apply-macete macete context expr)))


;;;(define GET-MACETE name->macete)

;;This procedure is defunct.

(define (THEORY-NONSIMPLE-INTERACTIVE-MACETES theory)
  (iterate loop ((all (table->set *macete-table*)) (sound '()))
    (cond  ((null? all) sound)
	   ((and (macete-sound-in-theory? (car all) theory)
		 (interactive-macete? (car all)))
	    (loop (cdr all) (cons (car all) sound)))
	   (else (loop (cdr all) sound)))))
    


