;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald SECTIONS)


;;; T primitives

(define IMPS-FILESPEC? (*value t-implementation-env 'filespec?))
(define IMPS-GET-DEFAULT-FILENAME (*value t-implementation-env 'get-default-filename))
(define IMPS-EXPAND-FILENAME (*value t-implementation-env 'expand-filename))
(define IMPS-FILENAME->STRING (*value t-implementation-env 'filename->string))

(define (IMPS-FILESPEC->STRING spec)
  (imps-filename->string (imps-expand-filename (imps-get-default-filename spec))))

(define (IMPS-FILESPEC-EQUAL? spec1 spec2)
  (string-equal? (imps-filespec->string spec1)
		 (imps-filespec->string spec2)))


;;; Tables

(lset *NAME-SECTION-TABLE* (make-table '*name-section-table*))

(define (NAME->SECTION the-name)
  (table-entry *name-section-table* the-name))

(lset *LOADED-FILES-TABLE* (make-string-table '*loaded-files-table*))

(define (IMPS-FILE-LOADED? spec)
  (table-entry *loaded-files-table* 
	       (imps-filespec->string spec)))


;;; Sections

(define-structure-type SECTION
  name					; symbol-form
  component-names			; list of symbol-forms
  filespecs				; list of file specs
  aux-filespec				; file spec
  loaded?				; boolean
  obarray-entries			; list of imps obarray entries for
					; eventual use by Emacs 

  (((name self)
    (section-name self))
   ((print self port)
    (format port 
	    "#{IMPS-section ~A: ~S}"
	    (object-hash self)
	    (section-name self)))))

(define (BUILD-SECTION the-name component-names filespecs aux-filespec)
  (or (symbol? the-name)
      (imps-error "BUILD-SECTION: ~A ~S ~A"
		  "the section name" the-name "is not a symbol."))
  (map 
   (lambda (comp-name)
     (or (symbol? comp-name)
	 (imps-error "BUILD-SECTION: ~A ~S ~A"
		     "the component section name" comp-name "is not a symbol.")))
   component-names)
  (map 
   (lambda (spec)
     (or (imps-filespec? spec)
	 (imps-error "BUILD-SECTION: ~S ~A"
		     spec "is not a file specification.")))
   (if aux-filespec
       (cons aux-filespec filespecs)
       filespecs))
  (let ((old-section (name->section the-name)))
    (if old-section
	(block (or (and (every? 
			 eq? 
			 (section-component-names old-section)
			 component-names)
			(every?
			 imps-filespec-equal?
			 (if (section-aux-filespec old-section)
			     (cons (section-aux-filespec old-section)
				   (section-filespecs old-section))
			     (section-filespecs old-section))
			 (if aux-filespec
			     (cons aux-filespec filespecs)
			     filespecs)))
		   (imps-error "BUILD-SECTION: ~A ~S."
			       "there is already a section named" the-name))
	       old-section)
	(let ((new-section (make-section)))
	  (set (table-entry *name-section-table* the-name) new-section)
	  (set (section-name new-section) the-name)
	  (set (section-component-names new-section) component-names)
	  (set (section-filespecs new-section) filespecs)
	  (set (section-aux-filespec new-section) aux-filespec)
	  (set (section-loaded? new-section) '#f)
	  (set (section-obarray-entries new-section) '())
	  new-section))))


;;; Loading sections and files

(let ((imps-sections-active '()))
  (define (current-imps-section)		; being loaded at any time.  
    (car imps-sections-active))

  (define (push-imps-section section)
    (push imps-sections-active
	  (enforce section? section)))

  (define (pop-imps-section)
    (pop imps-sections-active)))
    
    
(define (LOAD-IMPS-SECTION the-name reload-files-only? reload? quick?)
  (let ((section (name->section the-name)))
    (or section
	(imps-error "LOAD-IMPS-SECTION: ~A ~S."
		    "there is no section named" the-name))
    (bind (((quick-load?) quick?)
	   ((*value t-implementation-env '*load-level*)
	    (1+ (*value t-implementation-env '*load-level*))))
      (if (and (section-loaded? section)
	       reload-files-only?)
	  (block
	    (format-imps-load-message (standard-output) "~A ~S.~%"
				      "Reloading files of IMPS section" the-name)
	    (load-imps-section-files section '#t)
	    (format-imps-load-message (standard-output) "~S ~A.~%"
				      the-name "files are reloaded"))
	  (load-imps-section-aux section reload?)))))

(define (LOAD-IMPS-SECTION-AUX section reload?)
  (push-imps-section section)
  (unwind-protect
   (cond ((and (section-loaded? section) (not reload?))
	  (format-imps-load-message
	   (standard-output) "~A ~S.~%"
	   "Already loaded IMPS section" (section-name section)))
	 ((and (section-loaded? section) reload?)
	  (format-imps-load-message
	   (standard-output) "~A ~S.~%"
	   "Reloading IMPS section" (section-name section))
	  (load-imps-component-sections section reload?)
	  (load-imps-section-files section reload?)
	  (set (section-loaded? section) '#t)
	  (format-imps-load-message
	   (standard-output) "~S ~A.~%"
	   (section-name section) "is reloaded"))
	 (else 
	  ;; (not (section-loaded? section))
	  (format-imps-load-message
	   (standard-output) "~A ~S.~%"
	   "Loading IMPS section" (section-name section))
	  (load-imps-component-sections section reload?)
	  (load-imps-section-files section reload?)
	  (set (section-loaded? section) '#t)
	  (format-imps-load-message
	   (standard-output) "~S ~A.~%"
	   (section-name section) "is loaded")))
   (pop-imps-section))
  (maybe-install-section-in-emacs-obarray section))
	 
(define (LOAD-IMPS-COMPONENT-SECTIONS section reload?)
  (bind (((*value t-implementation-env '*load-level*)
	  (1+ (*value t-implementation-env '*load-level*))))
    (walk
     (lambda (comp-name)
       (let ((comp (name->section comp-name)))
	 (load-imps-section-aux comp reload?)))
     (section-component-names section))))

(define (LOAD-IMPS-SECTION-FILES section reload?)
  (load-imps-files (section-filespecs section)  reload?))

(define (LOAD-IMPS-FILES filespecs reload?)
  (walk
   (lambda (filespec)
     (load-imps-file filespec reload?))
   filespecs)
  (return))

(define (LOAD-IMPS-FILE spec reload?)
  (if 
   (or (not (imps-file-loaded? spec))
       reload?)
   (block
     (push-current-theory)
     (push-current-syntax)
     (format-imps-load-message (standard-output) "~A ~S.~%"
			       (if reload?
				   "  Reloading IMPS file"
				   "  Loading IMPS file")
			       (imps-filespec->string spec))
     ;;
     ;; ((*value t-implementation-env 'load-silently) spec imps-implementation-env)
     ;;
     (load-imps-file-load-port spec)
     (format-imps-load-message (standard-output) "~A.~%" "  File is loaded")
     (pop-current-syntax)
     (pop-current-theory)
     (set 
      (table-entry *loaded-files-table* (imps-filespec->string spec))
      '#t))))

(define (format-imps-load-message port format-string . args)
  ((*value t-implementation-env 'COMMENT-INDENT)
      (standard-output)
      (fx* (*value t-implementation-env '*load-level*) 2))
  (apply format port format-string args))

(define-predicate line-numbered-port?)
(define-operation port-line-number)

(define (port->line-numbered-port port)
  (let ((newline-recently? '#f)
	(current-line-number 0))
    (join 
      (object '()
	((port-name self)
	 (format nil "~a" (port-name port)))
	((line-numbered-port? self) '#t)
	((port-line-number self) current-line-number)
	((read-char self)
	 (let ((ch (read-char port)))
	   (cond ((eq? ch '#\newline)
		  (increment current-line-number)
		  (set newline-recently? '#t))
		 (else (set newline-recently? '#f)))
	   ch))
	((unread-char self)
	 (if newline-recently? (decrement current-line-number))
	 (unread-char port)))
      port)))

(define current-imps-port
  (make-simple-switch
   'current-imps-port
   (lambda (val)(or (not val) (port? val)))
   '#f))

(define (current-imps-directory)
  (let ((dir
	 (filename-dir
	  (->filename
	   (port-name
	    (current-imps-port))))))
    (if (string? dir)
	(string-append dir "/")
	(symbol->string (concatenate-symbol '$ dir '/)))))
    
   
(define (current-imps-filename-nondirectory)
  (let ((fn (imps-expand-filename
	     (->filename
	      (port-name
	       (current-imps-port))))))
    (if (and (string? (filename-name fn))
	     (string? (filename-type fn)))
	(string-append
	 (filename-name fn)
	 "."
	 (filename-type fn))
	"anonymous")))


(define def-form-end-line (make-simple-switch 'def-form-end-line (always '#t) '#f))
(define def-form-name	  (make-simple-switch 'def-form-name	 (always '#t) '#f))
(define def-form-kind	  (make-simple-switch 'def-form-kind	 (always '#t) '#f))

(define (load-imps-file-load-port spec)
  (bind (((print-load-message?) nil)
         ((print-env-warnings?) nil)
	 ((*value t-implementation-env '+load-noisily?+) '#f))
    (with-open-ports
	((port
	  (port->line-numbered-port
	   ((*value t-implementation-env 'open-default-filename)
	    spec '#t))))
      (bind (((current-imps-port) port))
	(cond ((port? port) 
	       ((*value t-implementation-env 'load-port)
		port imps-implementation-env))
	      (else nil))))))

(define-structure-type imps-obarray-entry
  name
  kind
  directory
  file
  line
  def-name
  section-name 

  (((print self port)
    (format port "~%#{IMPS-obarray-entry ~a ~a ~s ~s ~a ~a ~a #}"
	    (imps-obarray-entry-name self)
	    (imps-obarray-entry-kind self)
	    (imps-obarray-entry-directory self)
	    (imps-obarray-entry-file self)
	    (imps-obarray-entry-line self)
	    (and (symbol? (imps-obarray-entry-def-name self))
		 (imps-obarray-entry-def-name self))
	    (imps-obarray-entry-section-name self)))))

(define (downcase-object obj)
  (cond ((symbol? obj) (string-downcase (symbol->string obj)))
	((string? obj) (string-downcase obj))
	(else (string-downcase (format nil "~A" obj)))))


(define (build-imps-obarray-entry name kind directory file line def-name section)
  (let ((entry (make-imps-obarray-entry)))
    (set (imps-obarray-entry-name entry) (downcase-object name))
    (set (imps-obarray-entry-kind entry) (downcase-object kind))
    (set (imps-obarray-entry-directory entry) directory)
    (set (imps-obarray-entry-file entry) file)
    (set (imps-obarray-entry-line entry) line)
    (set (imps-obarray-entry-def-name entry) (downcase-object def-name))
    (set (imps-obarray-entry-section-name entry) (downcase-object section))
    entry))

(define imps-obarray-port
  (make-simple-switch 'imps-obarray-port (lambda (p)(or (false? p)(port? p)))
		      '#f))

(define (register-current-imps-obarray-entry)
  (register-imps-obarray-entry (def-form-name) (def-form-kind)))

(define (register-imps-obarray-entry the-name kind)
  (let ((entry 
	  (build-imps-obarray-entry
	   the-name kind
	   (current-imps-directory) (current-imps-filename-nondirectory)
	   (def-form-end-line) (def-form-name)
	   (and (current-imps-section)
		(name (current-imps-section))))))
    (if (section? (current-imps-section))
	(push (section-obarray-entries
	       (current-imps-section))
	      entry)
	(and (port? (imps-obarray-port))
	     (print entry (imps-obarray-port))))))

(define (emacs-install-from-obarray-port)
  (force-output (imps-obarray-port))
  (emacs-eval
   (format
    nil 
    "(augment-imps-obarray-from-file (substitute-in-file-name '~S))"
    ((*value t-implementation-env 'port-truename) (imps-obarray-port)))))

(define (maybe-register-imps-obarray-entry the-name kind)
  (or (not the-name)
      (and (eq? the-name (def-form-name))
	   (eq? kind     (def-form-kind)))
      (register-imps-obarray-entry the-name kind)))

(define (section-print-imps-obarray-entries section port)
  (walk
   (lambda (entry)
     (if (imps-obarray-entry-name entry)
	 (print entry port)))
   (section-obarray-entries section))
  (return))

(define (section-update-auxiliary-file section)
  (let ((fn (->filename (section-aux-filespec section)))
	(maybe-open-port-in-directory
	 (lambda (dir)
	   (maybe-open
	    (->filename
	     (list dir
		   (concatenate-symbol 'auxiliary-files/ (name section))
		   'aux))
	    '(out))))
	(use-port
	 (lambda (port)
	   (set (section-aux-filespec section)
		(imps-filename->string (port-name port)))
	   (with-open-ports ((port port))
	     (section-print-imps-obarray-entries section port)))))
    
    (use-port
     (or
      (and fn (maybe-open fn '(out)))
      (maybe-open-port-in-directory (imps-auxiliary-file-dir))
      (maybe-open-port-in-directory 'imps_aux)
      (maybe-open-port-in-directory (working-directory))
      (maybe-open-port-in-directory 'home)
      (imps-error
       "section-update-auxiliary-file: could not open auxiliary file; 
	please specify in def-form for section ~S.
	The file must be writeable by you."
       section)))))

(define imps-auxiliary-file-dir
  (make-simple-switch 'imps-auxiliary-file-dir symbol? 'theories))

(define (section-retrieve-aux-dir-from-user)
  (imps-warning "Please switch to *tea* buffer and input
shell variable for directory in which to place section auxiliary files.")
  (retrieve-object-from-user
   "Shell variable name (for instance, HOME): "
   (standard-input) (standard-output) symbol?))

;; (define (section-needs-update? section)
;;   (let ((aux (section-aux-filespec section)))
;;     (or (not aux)
;; 	(any?
;; 	 (lambda (fspec)
;; 	   (file-newer? (->filename fspec) aux))
;; 	 (section-filespecs section)))))
    
(define (section-update-all-auxiliary-files)
  (walk-table
   (lambda (n section)
     (ignore n)
     (if (section-obarray-entries section)
	 (section-update-auxiliary-file section)))
   *NAME-SECTION-TABLE*))

(define (section-update-auxiliary-files-when-loaded)
  (walk-table
   (lambda (n section)
     (ignore n)
     (if (and (section-obarray-entries section)
	      (section-loaded? section))
	 (section-update-auxiliary-file section)))
   *NAME-SECTION-TABLE*))

(define (currently-loaded-sections)
  (let ((accum '()))
    (walk-table
     (lambda (n section)
       (ignore n)
       (if (section-loaded? section)
	   (push accum section)))
     *NAME-SECTION-TABLE*)
    accum))

(define (currently-loaded-section-names)
  (map name (currently-loaded-sections)))

(define (section-aux-filename-with-defaults section)
  (let* ((section-name (name section))
	 (dir->filename
	  (lambda (dir)
	    (->filename
	     (list dir (concatenate-symbol 'auxiliary-files/ section-name) 'aux)))))
    (cond ((section-aux-filespec section) => ->filename)
	  ((any-such-that
	    (lambda (dir) (file-exists? (dir->filename dir)))
	    (list (imps-auxiliary-file-dir) 'imps_aux 'home))
	   => dir->filename)
	  (else '#f))))

(define (currently-loaded-section-aux-files)
  (iterate iter ((sections (currently-loaded-sections))
		 (aux-files '()))
    (cond ((null? sections) (reverse! aux-files))
	  ((section-aux-filename-with-defaults (car sections))
	   =>
	   (lambda (fn)
	     (iter (cdr sections)
		   (cons (imps-filename->string fn) aux-files))))
	  (else (iter (cdr sections) aux-files)))))

(define (expanded-section-aux-file section)
  (cond ((section-aux-filename-with-defaults section)
	 => imps-filename->string)
	(else '#f)))

(define (maybe-install-section-in-emacs-obarray section)
  (if (and (emacs-process-filter?)
	   (not (section-already-transmitted? section)))
      (block
	(add-section-already-transmitted section)
	(let ((aux-fn (expanded-section-aux-file section)))
	  (and aux-fn
	       (emacs-eval
		(format
		 nil 
		 "(augment-imps-obarray-from-file (substitute-in-file-name '~S))"
		 aux-fn)))))))

(define sections-already-transmitted
  (make-simple-switch
   'sections-already-transmitted
   (lambda (l)(every? section? l))
   '()))

(define (reset-sections-already-transmitted)
  (set (sections-already-transmitted) '()))

(define (add-section-already-transmitted section)
  (set (sections-already-transmitted)
       (cons section (sections-already-transmitted))))

(define (section-already-transmitted? section)
  (memq? section (sections-already-transmitted)))

(define (section-lower-case-names)
  (let ((accum `()))
    (walk-table
     (lambda (k v)
       (ignore k)
       (push accum
	     (string-downcase (symbol->string (section-name v)))))
     *name-section-table*)
    accum))

(define (emacs-install-section-references section-or-name)
  (let ((section
	 (if (section? section-or-name)
	     section-or-name
	     (name->section section-or-name))))
    (let ((fspec (section-aux-filename-with-defaults section)))
      (if (and (string? fspec) (string-empty? fspec))
	  (imps-warning "No auxiliary file with references for section ~A"
			(section-name section))
	  (emacs-eval
	   "(augment-imps-obarray-from-file
             (expand-file-name (substitute-in-file-name ~S)))"
	   (imps-filename->string fspec))))))


	     
	      
