;% Copyright (c) 1990-1994 The MITRE Corporation
;% 
;% Authors: W. M. Farmer, J. D. Guttman, F. J. Thayer
;%   
;% The MITRE Corporation (MITRE) provides this software to you without
;% charge to use, copy, modify or enhance for any legitimate purpose
;% provided you reproduce MITRE's copyright notice in any copy or
;% derivative work of this software.
;% 
;% This software is the copyright work of MITRE.  No ownership or other
;% proprietary interest in this software is granted you other than what
;% is granted in this license.
;% 
;% Any modification or enhancement of this software must identify the
;% part of this software that was modified, by whom and when, and must
;% inherit this license including its warranty disclaimers.
;% 
;% MITRE IS PROVIDING THE PRODUCT "AS IS" AND MAKES NO WARRANTY, EXPRESS
;% OR IMPLIED, AS TO THE ACCURACY, CAPABILITY, EFFICIENCY OR FUNCTIONING
;% OF THIS SOFTWARE AND DOCUMENTATION.  IN NO EVENT WILL MITRE BE LIABLE
;% FOR ANY GENERAL, CONSEQUENTIAL, INDIRECT, INCIDENTAL, EXEMPLARY OR
;% SPECIAL DAMAGES, EVEN IF MITRE HAS BEEN ADVISED OF THE POSSIBILITY OF
;% SUCH DAMAGES.
;% 
;% You, at your expense, hereby indemnify and hold harmless MITRE, its
;% Board of Trustees, officers, agents and employees, from any and all
;% liability or damages to third parties, including attorneys' fees,
;% court costs, and other related costs and expenses, arising out of your
;% use of this software irrespective of the cause of said liability.
;% 
;% The export from the United States or the subsequent reexport of this
;% software is subject to compliance with United States export control
;% and munitions control restrictions.  You agree that in the event you
;% seek to export this software or any derivative work thereof, you
;% assume full responsibility for obtaining all necessary export licenses
;% and approvals and for assuring compliance with applicable reexport
;% restrictions.
;% 
;% 
;% COPYRIGHT NOTICE INSERTED: Mon Apr 11 11:42:27 EDT 1994


(herald THEORY-TRANSFORM-INTERFACE)


;;provides an interface for creating simplifiers.

(define *processor-table* (make-table '*processor-table*))
  
(lset *rewrite-rules-list* '())

(define (INSTALL-TRANSFORM-AS-REWRITE-RULE transform)
  (push *rewrite-rules-list* transform))

(define (THEORY-INSTALL-TRANSFORM-IN-ALGEBRAIC-PROCESSORS theory transform)
  (if (and (rewrite-rule? transform)
	   (application? (rewrite-rule-lhs transform)))
      (let ((op (operator (rewrite-rule-lhs transform))))
	(walk-table
	 (lambda (k v)
	   (ignore k)
	   (if (and (algebraic-processor? v)
		    (memq? v (theory-valid-processors theory))
		    (memq? op (algebraic-processor-handled-operators v)))
	       (set (algebraic-processor-rewrite-rules v)
		    (add-set-element transform (algebraic-processor-rewrite-rules v)))))
	 *processor-table*)))
  (return))

(define (ALGEBRAIC-PROCESSOR-INSTALL-EXISTING-REWRITE-RULES-FROM-THEORY processor theory)
  (if (algebraic-processor? processor)
      (walk
       (lambda (r)
	 (if (and (rewrite-rule? r)
		  (application? (rewrite-rule-lhs r))
		  (memq? (operator (rewrite-rule-lhs r))
			 (algebraic-processor-handled-operators processor))
		  (theory-theorem? theory (rewrite-rule-formula r)))
	     (set (algebraic-processor-rewrite-rules processor)
		  (add-set-element r (algebraic-processor-rewrite-rules processor)))))
       *rewrite-rules-list*))
  (return))

(define (THEORY-INSTALL-EXISTING-REWRITE-RULES-IN-ALGEBRAIC-PROCESSORS theory)
  (walk-table
   (lambda (k v)
     (ignore k)
     (algebraic-processor-install-existing-rewrite-rules-from-theory v theory))
   *processor-table*))

(define (TABULATE-PROCESSOR-NAME name proc)
  (set (table-entry *processor-table* name) proc))
  
(define (NAME->PROCESSOR name)
  (table-entry *processor-table* name))

(define (CLEAR-PROCESSORS)
  (walk-table
   (lambda (k v) (ignore k) (clear-table (processor-reduced-terms v)))
   *processor-table*))

(define (CLEAR-TABLE table)
  (walk-table
   (lambda (k v) (ignore v) (set (table-entry table k) '#f))
   table))

(define (ALGEBRAIC-PROCESSOR-FROM-DEFINITION form)
  (let* ((language (or (name->language (cadr (assq 'language (cdr form))))
		       (theory-language (name->theory (cadr (assq 'language (cdr form)))))))
	 (base-proc (make-processor-from-form language (cadr (assq 'base (cdr form)))))
	 (exponent-proc (let ((entry (cadr (assq 'exponent (cdr form)))))
			  (if entry
			      (if (symbol? entry)
				  (name->processor entry)
			  
				  (make-processor-from-form language entry))
							  
			      '#f)))
	 (scalar-proc (let ((entry (cadr (assq 'coefficient (cdr form)))))
			(if entry
			    (if (symbol? entry)
				(name->processor entry)
			  
				(make-processor-from-form language entry))
							  
			    '#f))))
    (if exponent-proc
	(set (algebraic-processor-exponent-processor base-proc) exponent-proc))
    (if scalar-proc
	(set (algebraic-processor-coefficient-processor base-proc) scalar-proc))
    (if (car form) (tabulate-processor-name (car form) base-proc))
    base-proc))
	

(define (MAKE-PROCESSOR-FROM-FORM language form)
  (let ((scalars (if (assq 'scalars form)
		     (eval (cadr (assq 'scalars form)) (the-environment))
		      *integer-type*))
	(coertion (if (assq 'coertions form)
		      (cadr (assq 'coertion form))
		      '()))
	(operations-alist
	 (map (lambda (x) (list (car x) (find-constant language (cadr x))))
	      (cdr (assq 'operations form))))
	(numerals-for-ground-terms? (cadr (assq 'numerals-for-ground-terms? form)))
	(commutes (cadr (assq 'commutes form))))
    (ignore coertion) ;;for now.
    (let ((proc (build-algebraic-processor language scalars operations-alist commutes)))
      (if numerals-for-ground-terms? (use-numerals-for-ground-terms proc))
      proc)))
	   

(define (ORDER-PROCESSOR-FROM-DEFINITION form)
  (let* ((algebraic-processor (name->processor (cadr (assq 'algebraic-processor (cdr form)))))
	 (language (processor-language algebraic-processor))
	 (operations-alist
	  (map (lambda (x) (list (car x) (find-constant language (cadr x))))
	       (cdr (assq 'operations (cdr form)))))
	 (discrete-sorts
	  (map (lambda (discrete)
		 (list->sort language discrete))
	       (cdr (assq 'discrete-sorts (cdr form)))))
	 (proc (build-order-processor-from-algebraic-processor
		algebraic-processor
		operations-alist
		discrete-sorts)))
    (if (car form) (tabulate-processor-name (car form) proc))
    proc))
    
(define (THEORY-BUILD-TRANSFORM-TABLE theory)
  (set (theory-transform-table theory) (make-table)))

(define (THEORY-ADD-ALGEBRAIC-SIMPLIFIER theory processor operations)
  (algebraic-processor-install-existing-rewrite-rules-from-theory processor theory)
  (let ((simplifier 
	 (lambda (context expr persist)
	   (algebraic-processor-simplify-with-requirements processor context expr persist))))
    (walk (lambda (x)
	    (let ((c (find-constant (theory-language theory) x)))
	      (theory-install-transform
	       theory
	       apply-operator
	       c
	       simplifier)))
	  operations)))

(define (THEORY-ADD-ORDER-SIMPLIFIER theory processor operations)
  (let ((order-simplifier 
	 (lambda (context expr persist)
	   (order-processor-simplify-with-requirements processor context expr persist))))
    (walk (lambda (x)
	    (let ((c (find-constant (theory-language theory) x)))
	      (theory-install-transform
	       theory
	       apply-operator
	       c
	       order-simplifier)))
	  operations)))

(define (THEORY-ADD-EQUALITY-COMPARATOR theory processor)
;;  (let ((equality-processor (build-equality-processor processor))))
    (theory-install-transform
     theory
     equality
     'no-lead-constant
     (lambda (context expr persist)
       (processor-simplify-equality-with-requirements processor context expr persist))))


;(term-simplifier-from-derfinition forms) where forms is a list
;(theory th)
;(include th1 th2 ... )
;(algebraic-simplifier (processor1 op-list1) (processor2 op-list2) ...)
;(algebraic-order-simplifier (processor1 op-list1) (processor2 op-list2) ...)
;(algebraic-term-comparator (processor))
;(rewrites r1 r2  ...)
;(transportable-rewrites th1 th2 ... )

(define (TERM-SIMPLIFIER-FROM-DEFINITION form)
  (let ((theory (name->theory (cadr (assq 'theory form))))
	(includes (cdr (assq 'include form)))
	(algebraic-simplifier-forms (cdr (assq 'algebraic-simplifier form)))

	(order-simplifier-forms (cdr (assq 'algebraic-order-simplifier form)))
	(term-comparator-forms (cdr (assq 'algebraic-term-comparator form)))
;;;	(rewrite-rule-forms (cdr (assq 'rewrites form)))
	(transportable-rewrite-rule-forms (cdr (assq 'transportable-rewrites form))))
    
    (set (theory-transform-table theory)
	 (join-theory-transform-tables 

	  ;;get the corresponding transform handlers for the included theories:
	  (cons (theory-transform-table theory)
		;;make sure we don't lose anything!
		(map
		 (lambda (x)
		   (let ((th (name->theory x)))
		     (enforce (lambda (y) (subtheory? y theory)) th)
		     ;;this insures that each theory in INCLUDES is the name of
		     ;;a valid theory TH which is a subtheory of THEORY.
		     (theory-transform-table th)))
		 includes))))
    (or (quick-load?)
	;; If quick-loading (that is (quick-load?) is #t) then 
	;; don't evaluate:
	(if (or algebraic-simplifier-forms order-simplifier-forms)

	    ;;(format t "~%;Checking soundness of algebraic processors...~%")

	    (if (not (every?
		      (lambda (x) (processor-sound-in-theory?
				   (name->processor (car x))
				   theory))
		      (union algebraic-simplifier-forms order-simplifier-forms)))
		(imps-error "Algebraic Processor Soundness failed."))))
		   
    (walk
     (lambda (x)
       (theory-add-algebraic-simplifier theory (name->processor (car x)) (cadr x)))
     algebraic-simplifier-forms)
    (walk
     (lambda (x)
       (theory-add-order-simplifier theory (name->processor (car x)) (cadr x)))
     order-simplifier-forms)
    (if term-comparator-forms
	(walk (lambda (x)
		(theory-add-equality-comparator theory (name->processor x)))
	      term-comparator-forms))
;;;    (walk
;;;     (lambda (x)
;;;       (theory-add-rewrite-rule
;;;	theory
;;;	(qr (car x) (theory-language theory))))
;;;     rewrite-rule-forms)
    (theory-import-transportable-rewrite-rules
     theory
     (map name->theory transportable-rewrite-rule-forms))
    (theory-transform-table theory)))

       

    
