/******************************************************************************
  anf_ceiling_alloc.c
******************************************************************************/
 
#include "kant.h"

anf_ceiling
anf_ceiling_alloc WITH_1_ARG(
	order,		ord
)
/*******************************************************************************
 
Description:
 
	Allocating space for a ceiling over an algebraic number field.
 
        The Lambda vector is only allocated while the exponent 
        vector is allocated and filled with zeros.
  
Calling sequence:
 
	ceil = anf_ceiling_alloc(ord);

	order		ord	= order over which ceil is defined
	anf_ceiling	ceil	= created ceiling (almost empty)

History:
 
	92-06-04  JS    first version
 
*******************************************************************************/
{
	anf_ceiling	ceil;
        integer_small   deg, i;

	ceil = mem_alloc_zero(sizeof(anf_ceiling_struct));
 
	block_init(ceil, ANF_CEILING_BLOCK_TYPE);
                            
        deg = order_abs_degree(ord);
 
        anf_ceiling_lambdas(ceil) = vec_new(deg);
        anf_ceiling_rexps(ceil)   = vec_new(deg);
        
        for (i=1; i<=deg; i++) anf_ceiling_rexp(ceil, i) = 0;

	return ceil;
}

