/******************************************************************************
  anf_dump.c                                                           
******************************************************************************/

#include <stdio.h>
#include "kant.h"
#include "mat.h"
#include "ring.h"
#include "anf.h"
#include "poly.e"
#include "dyn_arr.h"

 
#define cnt(h) block_ref_count(h)
#define prnt   printf("     "), printf
 
void
anf_dump WITH_1_ARG(
	anf,       field
)
/*******************************************************************************
 
Description:
 
       Prints out anf data. This routine is also called by
       order_dump.
 
 
Calling sequence:
 
	anf_dump(ord);
 
      	anf       field  = t_handle of field to dump
      
 
History:
 
	92-03-12 JS    first version
 
*******************************************************************************/
{
	
	order		ord;
	t_poly       pol;
        int             i, count;
 
        prnt("Start anf_dump of %d %d\n", field, cnt(field));
   
        prnt("Signature: %d %d %d %d\n",
                                anf_abs_degree(field),
                                anf_r1(field),
                                anf_r2(field),
                                anf_r(field));
 
        count = anf_order_count(field);
        prnt("Number of orders: %d",count);
	if (count)
        {
                printf(",  ");
                for (i=1; i<=count; ++i)
                {                          
                        ord = anf_order(field, i);
                        printf("  %d %d   ",ord, cnt(ord));
                }
        }
        printf("\n");
 
        count = anf_poly_z_count(field);
        prnt("Number of polynomials over Z: %d",count);
	if (count)
        {
                printf(",  ");
                for (i=1; i<=count; ++i)
                {                          
                        pol = m_poly_poly_to_handle(anf_poly_z_poly(field, i));
                        printf("  %d %d   ",pol, cnt(pol));
                }
        }
        printf("\n");
 
        count = anf_poly_order_count(field);
        prnt("Number of polynomials over orders: %d",count);
	if (count)
        {
                printf(",  ");
                for (i=1; i<=count; ++i)
                {                          
                        pol = m_poly_poly_to_handle(anf_poly_order_poly(field, i));
                        ord = anf_poly_order_order(field, i);
                        printf("  %d %d over %d %d  ",pol, cnt(pol),ord, cnt(ord));
                }
        }
        printf("\n");
 
        return;
}
