/******************************************************************************
  anf_elt_equal.c
******************************************************************************/
 
#include "kant.h"
#include "anf.h"

t_logical
anf_elt_equal WITH_3_ARGS(
	order,  	ord,
        anf_elt,	alpha,
	anf_elt,	beta
)
/*******************************************************************************
 
Description:
 
	Returns (alpha == beta).
 
  
Calling sequence:
 
	if (anf_elt_equal(ord, alpha, beta)) ...
                                                                       
        order           ord     = order over which alpha and beta are given
	anf_elt	        alpha   = first number
	anf_elt	        beta    = second number

History:
 
	92-05-07  JS    case that beta and not alpha is integer
	92-03-24  JS    first version
 
*******************************************************************************/
{
	block_declarations;         
 
	anf_elt		alpha1, beta1, gamma;
        integer_small   deg, i;
        order           ordcoef;
        t_handle          R;
        t_logical         eq;

        eq 	= TRUE;
        deg     = order_rel_degree(ord);
        ordcoef = order_coef_order(ord);
                                
/*
    one of the numbers is given via conjugates
*/
        if (anf_elt_is_con(beta))
        {
                gamma = beta;
                beta  = alpha;
                alpha = gamma;
        } 
                
/*
    now, if alpha or beta is in conjugates, alpha is in conjugates!
*/
        if (anf_elt_is_con(alpha))
        {   
                R	= order_reals(ord);
                alpha1  = anf_elt_incref(alpha);
                if (!anf_elt_is_con(beta))
                        beta1 = anf_elt_con(ord, beta);
                else
			beta1 = anf_elt_incref(beta1);
 
                for (i=1; i<=deg; ++i)
                { 
                        if (!real_eq(R, anf_con(alpha1, i), 
					      anf_con(beta1, i)))
                        {
                                eq = FALSE;
                                goto end;
                        }
                }
                goto end;
        }
  
/*
    first: simplification
*/
 
        alpha1 = anf_elt_simplify(ord, alpha);
        beta1  = anf_elt_simplify(ord, beta);
 
/*
    is one of the numbers an integer?
*/
 
        if (anf_elt_is_integer(alpha1))
        {
                if (!anf_elt_is_integer(beta1)) 
			eq = FALSE; 
                else 
			eq = !integer_compare(alpha1, beta1);
		goto end;
        }
        if (anf_elt_is_integer(beta1))
        {                             
                eq = FALSE;
		goto end;
        }
 
/*
    comparing denominators
*/      

        if (integer_compare(anf_elt_den(alpha1), anf_elt_den(beta1)))
        {  
                eq = FALSE;
		goto end;
        }
 
/*
    all coefficients
*/
 
        if (ring_type(ordcoef) == RING_Z)
        {
	        for (i=1; i<=deg; ++i)
                {
        	        if (integer_compare(anf_elt_coef(alpha1, i), 
			                    anf_elt_coef(beta1,  i)))
			{
				eq = FALSE;
                                goto end;
                        }
                }
        }
        else
        {
	        for (i=1; i<=deg; ++i)
                {
        	        if (!anf_elt_equal(ordcoef, anf_elt_coef(alpha1, i), 
					            anf_elt_coef(beta1,  i)))
			{
				eq = FALSE;
                                goto end;
                        }
                }
        }
end:
                 
        anf_elt_delete(ord, &alpha1);
        anf_elt_delete(ord, &beta1);
 
        return eq;
}
