/******************************************************************************
  anf_elt_is_unit.c
******************************************************************************/
#include "kant.h"

t_logical
anf_elt_is_unit WITH_2_ARGS (
	order,		ord,
	anf_elt,	alpha

)
/******************************************************************************
 
Description:	Tests whether an algebraic number is an unit.
 
Calling sequence:
 
	Bool = anf_elt_is_unit(ord,alpha)

	ord	:	the order alpha refers to
	alpha	:	the algebraic number to be tested
	Bool	:	TRUE	alpha is an unit
			FALSE	else
 
History:

	92-09-02 KW	trivial case (anf_elt_is_integer)
	92-08-12 KW	minor changes
	92-06-03 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		beta;
	integer_big	a,b;
	t_logical	bool;

	beta = anf_elt_simplify(ord,alpha);
	bool = (anf_elt_is_integer(beta)) || (anf_elt_den(beta) == 1);
	if (bool)
	{
		anf_norm(ord,beta,&a,&b);
		bool = (a == 1) || (a == -1);
		integer_delref(a);
	}
	anf_elt_delete(ord,&beta);

	return(bool);
}
