/*******************************************************************************
  anf_elt_power_mod.c
********************************************************************************/

#include "kant.h" 

anf_elt
anf_elt_power_mod  WITH_4_ARGS(
                               order,          ord,
                               integer_big,    modul,
                               anf_elt,        alpha,
                               integer_big,    expo  )

/*******************************************************************************
Description:
	Raise a given alg. number to given power with respect to a given modul.
        So the return value ( = beta) of this function will satisfy the 
        condition :
                                    expo 
                        beta = alpha     mod (modul*ord)

                 
Calling sequence:


        beta = anf_elt_power_mod (ord,modul,alpha,expo);


            order        ord   : all operations are done in the order.
            integer_big  modul : since we are computing something modular
                                 we need a modul. 
            anf_elt      alpha : alg. number defined over ord.
            integer_big expo   : the exponent to which alpha will be raised.

 
History:         

        MD 92-01-20 parameter expo can be an integer_big now.
        MD 25.10.91 first modular version.        
	KW 24.10.91 first non-modular version.
        
********************************************************************************/
{
        block_declarations;

        anf_elt         tempa,tempb,tempc;
        integer_big     expo_abs,q,r;


        tempa = anf_elt_incref(alpha);
 
        tempb = 1;                           

  if (integer_is_single (expo))
  {
    expo_abs = expo;
    for ( ; expo_abs != 0 ; expo_abs = expo_abs >> 1)
    {
      if ((expo_abs) & (1))
      {        
        tempc = tempb;
        tempb = anf_mult_mod (ord, modul, tempa, tempb);
        anf_elt_delref(ord,&tempc);
      }
    
      tempc = tempa;
      tempa = anf_mult_mod (ord, modul, tempa,tempa);
      anf_elt_delref(ord,&tempc);
    }
              

    anf_elt_delref(ord,&tempa); 
  
    return (tempb); 
  }
  else
  {
    expo_abs = integer_incref(expo);
                
    while (integer_compare(expo_abs,0))
    {
      integer_quot_rem(expo_abs,2,&q,&r);
      integer_delref(expo_abs);
      expo_abs = q;
        
      if (!(integer_compare(r,1)))
      {
        tempc = tempb;
        tempb = anf_mult_mod (ord,modul,tempa,tempb);
        anf_elt_delref(ord,&tempc);
      }
      integer_delref(r);

      tempc = tempa;
      tempa = anf_mult_mod (ord,modul,tempa,tempa);
      anf_elt_delref(ord,&tempc);
    }                

    anf_elt_delref(ord,&tempa); 
    
    if (integer_compare(expo,0) == -1)
    {
      tempc = tempb;
      tempb = anf_inverse(ord,tempb);
      anf_elt_delref(ord,&tempc);
    }


    return (tempb); 
  }
}
