/******************************************************************************
  anf_elt_reduce.c
******************************************************************************/
#include "kant.h"

anf_elt
anf_elt_reduce WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)

/******************************************************************************
 
Description:	Tries to find an associate algebraic number, whose 
		coefficients are smaller.
 
Calling sequence:
 
	result = anf_elt_reduce(ord,alpha)
 
History:
 
	92-06-26 KW	lat_vec_to_ref_vec
	92-06-05 KW	minor changes
	92-04-23 KW	written
 
******************************************************************************/
{
	block_declarations;

	anf_elt		beta,gamma;
	integer_small	i,r,r12;
	t_handle	R,Z;
	matrix		ortho,trans;
	lattice		lat;
	lat_enum_env	env;
	vector		b,e,v,w;

	lat = order_units_log_lat(ord);
	env = order_units_log_lat_env(ord);
	r   = order_r(ord);
	r12 = order_r1(ord) + order_r2(ord);
	R   = order_reals(ord);

/*
**	Compute projection into the logarithm lattice
*/
	v = anf_elt_logs(ord,alpha);        
	mat_real_orthonormal(R,lat_basis(lat),&ortho,&trans);
	w = vec_real_orthogonal_proj(R,ortho,v);

	mat_delref(R,&ortho);
	mat_delref(R,&trans);


/*
**	Compute the coordinates of the projection via the basis of the lattice
*/
	lat_vec_to_ref_vec(lat,env,w);
	lat_enum_request_set_shortest(env);
	lat_enum(lat,env);

	b = vec_new(r);
	e = vec_new(r);
	for (i=1;i<r12;i++)
	{
		vec_entry(e,i)
		= integer_incref(lat_elt_coef(lat_enum_act_coefs(env),i));
		vec_entry(b,i)
		= anf_elt_incref(order_unit(ord,i));
	}
	beta = anf_elt_power_product(ord,b,e);
	gamma = anf_mult(ord,alpha,beta);

	Z = structure_z;
	vec_delete(ord,&b);
	vec_delete(Z,&e);			
	vec_delete(R,&v);
	vec_delete(R,&w);
	anf_elt_delete(ord,&beta);

	return gamma;
}
