#include <stdio.h>         
#include "kant.h" 
#include "anf.h" 
#include "real.e"


t_real
anf_elt_t2  WITH_2_ARGS(
	order,		ord,
	anf_elt,	alpha
)
/*******************************************************************************
 
Description:
 
	The function returns the T_2-norm value of the element alpha in ord.

 
Calling sequence:
 
	norm= anf_elt_t2(ord, alpha);
 
      	order  	        ord      = t_handle of an order 
      	anf_elt         alpha    = t_handle of an algebraic number in ord
	t_real		norm	 = T_2-norm of alpha
      
 
History:
 
	92-04-01 AJ    written
 
*******************************************************************************/
{  
	block_declarations;         

  	int		i,j, r1, r2;
   	t_handle          R;
        t_real          norm, h1, h2, h3, two;
	vector		alpha_con;   
                                    

/*** Initialisation  **********************************************************/

	r1    = order_r1(ord);
	r2    = order_r2(ord);

        R = order_reals(ord); 

	two= conv_int_to_real(R,2);  

	alpha_con= anf_elt_abs(ord, alpha);


/*** T_2-norm of alpha  *******************************************************/
 
	
        norm= conv_int_to_real(R,0); 

   	for (i=r1+1; i<= r1+r2; i++)   
	 {
	  h1= norm;                
	  h3= real_mult(R, vec_entry(alpha_con,i), vec_entry(alpha_con,i) );
	  norm= real_add(R, norm, h3 );
	  real_delete(&h1);
	  real_delete(&h3);
	 }

	h1   = norm;
	norm = real_mult(R, h1, two );
	real_delete(&h1);
 
   	for (i=1; i<= r1; i++)   
	 {
	  h1= norm;
	  h3= real_mult(R, vec_entry(alpha_con,i), vec_entry(alpha_con,i) );
	  norm= real_add(R, norm, h3 );
	  real_delete(&h1);
	  real_delete(&h3);
	 }


	
/*** End: return the T_2-norm  ***********************************************/

	real_delete(&two); 
	vec_delete(R, &alpha_con);

	return norm;

} 

