/******************************************************************************
  anf_elt_to_mat_order_col.c                                                           
******************************************************************************/
         
#include "kant.h"
#include "mat.h"
#include "anf.h"


void
anf_elt_to_mat_order_col WITH_4_ARGS(
	order,		ord,
	anf_elt,	alpha,
	matrix,         mat,
	integer_small,	colno
)
/*******************************************************************************
 
Description:
 
	Converts the algebraic number alpha into a column of the matrix mat.
	This routine doesn't care for denominators. 
	The row dimension of mat should coincide with the relative degree of ord.
 
	Depending on whether alpha is given via its coefficients or via its 
	conjugate vectors the resulting column will consist of anf_elts or 
	of t_reals.
 
   
Calling sequence:
 
	anf_elt_to_mat_order_col(ord, alpha, mat, col);
 
      	order         ord   = t_handle of order alpha is given referring to
        anf_elt       alpha = algebraic number to move into mat   
      	matrix        mat   = t_handle of matrix to move in alpha
      	integer_small col   = the coeffs of alpha will be put into this column
 
History:
 
	92-03-31 JS    integer_anf_elt_lift
	91-09-01 JS    first version
 
*******************************************************************************/
{
	block_declarations;
 
	integer_small	deg;
	integer_small	i;
	anf_elt		beta;

 
	deg = order_rel_degree(ord);
 
	beta = anf_elt_is_integer(alpha)
                        ? integer_anf_elt_lift(ord, alpha)
			: anf_elt_incref(alpha);
 
	if (anf_elt_is_con(beta))
	{
		for (i=1; i<=deg; ++i)
		mat_elt(mat, i, colno) = real_incref(anf_con(beta, i));
	}
	else
	{
		for (i=1; i<=deg; ++i)
		mat_elt(mat, i, colno) = anf_elt_incref( anf_elt_coef(beta, i));
	}
 
	anf_elt_delete(ord, &beta);
  
	return;
}
 


