/*******************************************************************************
   anf_ideal_is_prime_ideal.c
********************************************************************************/



#include "kant.h"
#include "prime_cert.e"
#include "prime_cert.h"


t_logical 
anf_ideal_is_prime_ideal WITH_3_ARGS (order      , ord   ,
				      anf_ideal  , ideal ,
                                      anf_ideal* ,  new    )
/*******************************************************************************
 
Description:
   
    Checks if the ideal "ideal" is a prime ideal. In case it is not the function 
    retuns "FALSE" and the ideal "new" will be a true divisor of ideal.
    Otherwise the function returns "TRUE".

Calling sequence:
                                                           
      order       ord            :  The order ord has to be the ring of integers 
                                    of a number field.
      anf_ideal  ideal           :  The tested ideal.
      anf_ideal  new             :  In case "ideal" is not a prime ideal new will
                                    be a larger ideal.
      
      t_logical    is_prime        : Boolean return variable.

   
        is_prime = anf_ideal_is_prime_ideal (ord,ideal,&new);
                                                             
                            
History:                                 
           
     10.09.92   MD written

********************************************************************************/
{
             block_declarations;
             t_handle              Z;

             prime_cert_handle   cert;

             matrix              temp1,temp2,temp3,hnf_mat,rep_mat;


	     anf_elt             alpha;
             integer_big         i_norm,a_norm,den,gcd;
	     integer_small       n,i;
             t_logical             is_prime,ok;


  order_must_be_over_z (ord);

  anf_ideal_norm (ord,ideal,&i_norm,&den);  

  if (den != 1) 
    error_internal ("ANF_IDEAL_IS_PRIME_IDEAL : Ideal is frac.");

  if (!anf_ideal_is_z (ideal))
    anf_ideal_2_z (ord,ideal);


                 
  *new = MEM_NH;
  cert = prime_cert_alloc( 1 );

  if(!integer_is_prime( i_norm, cert, FALSE, 1000 ))
  {
    Z = m_z_str_incref(structure_z);
    n = order_abs_degree (ord);

    is_prime = TRUE;
 
    anf_ideal_remainder_init (&alpha);

    while (   (ok = anf_ideal_remainder_half_next (ord,ideal,&alpha))
	   && (is_prime)                                             )
    { 
/* printf ("testing next ...\n");anf_elt_write (ord,alpha);puts (""); */

      anf_elt_norm (ord,alpha,&a_norm,&den);
      gcd = integer_gcd (i_norm,a_norm);
      
      if ( (gcd != 1) && (gcd != -1) )
      {
        rep_mat = anf_rep_mat (ord,alpha);
        
        temp1 = mat_new (n,2*n);
        temp2 = mat_ring_insert (Z,temp1,rep_mat,1,n+1);
        temp3 = mat_ring_insert (Z,temp2,anf_ideal_tran (ideal),1,1);

        hnf_mat = mat_ring_hnf_col (Z,temp3);


        mat_delref (Z,&rep_mat);
        mat_delref (Z,&temp1);
        mat_delref (Z,&temp2);
        mat_delref (Z,&temp3);

        temp1 = mat_ring_submat (Z,hnf_mat,1,1,n,n);
        temp2 = mat_ring_subtract (Z,anf_ideal_tran (ideal),temp1); 

        if ( (!mat_ring_is_one (Z,temp1)) && (!mat_ring_is_zero (Z,temp2)) )
        {
          is_prime = FALSE;
          den  = 1;
          *new = anf_ideal_z_create (ord,temp1,den);
	  anf_ideal_tran_hnf(*new) = -1;
        }
        mat_delref (Z,&hnf_mat);
        mat_delref (Z,&temp1);
        mat_delref (Z,&temp2);
       
      }

      integer_delref (gcd); 
      integer_delref (a_norm);

    }

    ring_delete (&Z);
    anf_elt_delete (ord,&alpha);
  }
  else
    is_prime = TRUE;

  integer_delref (i_norm);

  prime_cert_clean( cert );
  prime_cert_delete( &cert );


  return is_prime;

}
