/******************************************************************************
  anf_ideal_power.c
******************************************************************************/
#include "kant.h" 

anf_ideal
anf_ideal_power WITH_3_ARGS(
        order,		ord,
        anf_ideal,	id,
        integer_small,	expo
)

/*******************************************************************************

Description:

	Superfluous.
                                       
Calling sequence: 

	idpow = anf_ideal_power(ord,id,expo)

	expo must be a small non-negative integer.
	
History:

	93-02-23 KW	anf_ideal_incref
	93-02-18 KW	written (using anf_power)
 
*******************************************************************************/
{
        block_declarations;

        anf_ideal	ida,ide,idu;

	if (!integer_is_single(expo) || (expo <0))
		error_internal("anf_ideal_power: exponent is bad.");

	if (!expo)
	{
		ida = anf_ideal_alloc();
		anf_ideal_gen1(ida) = anf_ideal_gen2(ida) = anf_ideal_gen_g(ida) = 1;

		return(ida);
	}

	ida = anf_ideal_incref(id);
	idu = 0;                        

	for (;expo;expo>>=1)
	{
		if (expo & 1) 
		{
			if (idu)
			{
				ide = idu;
				idu = anf_ideal_mult(ord,ida,idu);
				anf_ideal_delete(ord,&ide);
			}
			else idu = anf_ideal_incref(ida);
		}
		ide = ida;
		ida = anf_ideal_mult(ord,ida,ida);
		anf_ideal_delete(ord,&ide);
	}
	anf_ideal_delete(ord,&ida);

	return(idu); 
}
