/******************************************************************************
  anf_ideal_z_create.c
******************************************************************************/
 
#include "kant.h"
#include "mat.h"
#include "anf.h"

anf_ideal
anf_ideal_z_create WITH_3_ARGS(
	order,  	ord,
        matrix,		trans,
	integer_big,	den
)
/*******************************************************************************
 
Description:
 
	Creates the ideal given by the transformation matrix trans and the
        denominator den. 
        No care is taken for the fact that trans might be given in Hermite 
        normal form.
 
  
Calling sequence:
 
	id = anf_ideal_z_create(ord, trans, den);
                                                                       
        order           ord     = order over which id will be defined
        matrix    	trans   = transformation matrix, referring to order basis
        integer_big     den     = denominator of transformation
	anf_ideal	id	= created ideal in Z-basis presentation

History:
 
	92-03-17  JS    first version
 
*******************************************************************************/
{
	block_declarations;         
 
	anf_ideal	id;
 
        id = anf_ideal_alloc();
 
        anf_ideal_tran(id)     = mat_incref(trans);
        anf_ideal_tran_den(id) = integer_incref(den);
 
	return id;
}
