/*******************************************************************************
  integer_prime_exponent.c 
********************************************************************************/


       
#include <stdio.h>
#include "kant.h" 
#include "integer.e" 


integer_small 
integer_prime_exponent WITH_2_ARGS ( integer_big,       p,
                                     integer_big,       n )
/*******************************************************************************

Description:                               

   Calculates a integer prime_exponent with :
          
              prime_exponent-1         prime_exponent 
             p                 < n <= p           


Calling sequence:                                      
                                        
              integer_big        p;
              integer_big        n;
        
              integer_small      prime_exponent; 

            
          prime_exponent = integer_prime_exponent (p,n);
       
   The return value is described above.
                                                                     

History:  
                                                               
       MD 91-11-23         : first version                
                                                    
********************************************************************************/
{ 
     integer_big          potenz;
     integer_small        p_exponent;
    

  p_exponent = 0;
  potenz     = 1;

  do
  {               
    potenz = integer_mult (p,potenz);
    p_exponent++;
  }
  while (integer_compare(potenz,n) == -1);
  
  return p_exponent;
}                             
