/*******************************************************************************
  integer_prime_val.c 
********************************************************************************/
 
#include "kant.h" 
#include "integer.e" 

integer_small 
integer_prime_val WITH_2_ARGS (integer_big,       n,
                               integer_big,       p )
/*******************************************************************************

Description:                               

   Calculates the unique number v such that 
          
              v               (v+1)
             p  | n    and   p      not | n


Calling sequence:
 
              v = integer_prime_val(n, p);
                                              
              declarations are obvious!
               
 
History:  
                                                               
	92-07-14 JS/MD  & before q and r
	92-05-05 JS	first version
                                                    
********************************************************************************/
{ 
        block_declarations;
 
	integer_small 	v;
        integer_big     temp, q, r;
        
        if (n == 1 || n == -1) return 0;
 
	v    = -1;                    
        r    =  0;
        temp = integer_incref(n);
 
        while (!r)
        {
                integer_quot_rem(temp, p, &q, &r);
                integer_delref(temp);
                temp = q;
                v++;
        }
 
        integer_delref(temp);
        integer_delref(r);
 
        return v;
}
