/******************************************************************************
  lat_elt_delete.c
******************************************************************************/
#include "kant.h"
#include "integer.e"
#include "lattice.h"

void
lat_elt_delete WITH_2_ARGS(
	t_handle,		lat,
	lat_elt *,	elt
)
/******************************************************************************
 
Description:	Deletes a lattice element. The element is delreffed. 
		If there are no other references it is deleted completely.
 
Calling sequence:
 
	lat_elt_delete(lat,&elt)

	lattice		lat	= t_handle of lattice
	lat_elt		elt	= t_handle of lattice element to be deleted
 
History:
 
	92-03-?? KW	minor changes
	92-01-?? JS	written
 
******************************************************************************/
{
	block_declarations;
 
	integer_small	rank, i;

	if (!lat_elt_has_other_refs(*elt))
	{
             	rank = lat_rank(lat);
		for(i=1; i<=rank; ++i)
			integer_delref(lat_elt_coef(*elt, i));
	}

	block_decref_delete(*elt);
 
	*elt = MEM_NH;
 
	return;
}
