/******************************************************************************
  lat_elt_write.c
******************************************************************************/
#include "kant.h"

t_void
lat_elt_write WITH_2_ARGS (
	lattice,	lat,
	lat_elt,	elt
)
/******************************************************************************
 
Description: Prints a lattice element in the form [<coef>,...,<coef>].
 
Calling sequence:
 
	lat_elt_write(lat,elt);

	lattice	 lat	: the lattice elt refers to
	lat_elt	 elt	: the lattice element to be printed
 
History:

	92-06-25 KW	minor changes
	92-03-18 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,rank;

	rank = lat_rank(lat);
	printf("[ ");
	for(i=1;i<rank;i++) cay_print("%d,",lat_elt_coef(elt,i));
	cay_print("%d",lat_elt_coef(elt,rank));
	printf(" ]");
}
	
