/******************************************************************************
	mat_real_lin_equation.c
******************************************************************************/
#include "kant.h"

vector
mat_real_lin_equation WITH_3_ARGS(
	t_handle,	rrng,
	matrix,		a,
	vector,		b	
)

/******************************************************************************
 
Description:	Computes a solution x of a real linear equation system A*x = b.

		Note: If mat is a mxn-matrix its rank must be min(m,n).

Calling sequence:
 
		x = mat_real_lin_equation(rrng,a,b)

		t_handle	rrng	: the real ring of the coefficients
		matrix		a	: see above
		vector		b	: see above
		vector		x	: see above
 
History:
 
	92-06-26 KW	written
 
******************************************************************************/
{
	block_declarations;

	integer_small	i,k;
	integer_small	col,row;
	t_logical		cflag;
	matrix		echo,ltrans,rtrans;
	vector		bt,x,y;

	col = mat_col(a);
	row = mat_row(a);
	k = integer_min(col,row);

	if (row != vec_length(b))
		error_internal("mat_real_lin_equatation_system: incompatible dimensions");

	cflag = (col > row);
	mat_real_echelon(rrng,a,&echo,&ltrans,cflag,&rtrans);

	bt = mat_vector_col_mult(rrng,ltrans,b);
	x  = vec_new(col);
	for (i=1;i<=k;i++)
	{
		vec_entry(x,i) = real_divide(rrng,vec_entry(bt,i),mat_elt(echo,i,i));
	}
	for (i=k+1;i<=col;i++)
	{
		vec_entry(x,i) = ring_zero(rrng);
	}
	if (cflag)
	{
		y = x;
		x = mat_vector_col_mult(rrng,rtrans,x);
		mat_delref(rrng,&rtrans);
		vec_delete(rrng,&y);
	}

	mat_delref(rrng,&echo);
	mat_delref(rrng,&ltrans);
	vec_delete(rrng,&bt);  

	return(x);
}
