#include "kant.h"

t_void
mat_ring_add_sub WITH_4_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b,
	matrix	*,	result
)
/*
** *result := a + b, a and b matrices over coefficient ring cring.
*/
{
	t_logical respack;
	t_int		ma;
	t_int		na;
	t_int		mb;
	t_int		nb;
	matrix	adash;
	matrix	bdash;
	matrix	resultdash;
	t_int		i;
	t_int		j;
	t_ring_elt	(*ringadd)();

	switch( ring_type( cring ))
	{
/*	case RING_GFP:
	case RING_GFQ:
		mat_gf_add_sub( cring, a, b, result );
		return;*/ /* KW 1992-06-26 */

	case RING_Z:
		mat_z_add_sub( cring, a, b, result );
		return;

	case RING_ZM:
		mat_zm_add_sub( cring, a, b, result );
		return;

	default:
		break;
	}

	adash = bdash = resultdash = 0;
	ma = mat_row(a);
	na = mat_col(a);
	mb = mat_row(b);
	nb = mat_col(b);

	if ((ma != mb) || (na != nb))
		error_internal("Incompatible matrices for subtraction");

	respack = mat_result_pkd(cring, *result);
	ringadd = ring_addition(cring);

	mat_alloc_result_unpkd(respack, *result, resultdash, ma ,na);
	mat_create_unpkd(cring, a, adash, ma, na);
	mat_create_unpkd(cring, b, bdash, ma, na);

	for (i = 1; i <= ma*na; i++)
	{
		mat_entry(resultdash, i) =
			(*ringadd)(cring, mat_entry(adash, i), mat_entry(bdash, i));
	}
			
	mat_create_result(cring, respack, *result, resultdash);
	mat_free_unpkd(a, adash);
	mat_free_unpkd(b, bdash);
}


matrix 
mat_ring_add WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	matrix,	b
)
/*
** Returns a + b, a and b matrices over coefficient ring cring.
*/
{
	matrix	result = 0;
	mat_ring_add_sub(cring, a, b, &result);
	return result;
}

