#include "kant.h"
#include "ring.h"
#include "mat.h"
#include "integer.e"
#include "vector.h"



vector 
mat_ring_solve_equat WITH_3_ARGS(
	t_handle,	cring,
	matrix,	a,
	vector,	b
)
/*
** Returns the solution x of a linear equation system ax= b, 
   where a is a  matrix and b a vector 
** over the coefficient ring cring.
*/
{
	block_declarations;         

	matrix	        mat1, mat2, mat3;
	vector	        x;
	integer_small	i, j, n, k, dim1;
	integer_big     det1;
	t_logical 	unit;  
               
	
	n= mat_row(a);		
	k= mat_col(a);		

	mat1= mat_new(n,k+1);
	for (i=1; i<= n; i++)
  	  for (j=1; j<= k; j++)
	    mat_elt(mat1, i, j)= ring_elt_incref(cring,mat_elt(a, i, j));	

  	for (j=1; j<= n; j++)
	  mat_elt(mat1, j, k+1)= ring_elt_incref(cring, vec_entry(b, j));	

	mat2= 0;
	mat3= 0;
	mat_fld_echelon(cring, mat1, &det1, &dim1, &mat2, &unit, 1, &mat3, 0, 1);

	x= vec_new(k);

  	for (j=1; j<= k; j++)
	  vec_entry(x, j)= ring_elt_incref(cring, mat_elt(mat2, j, k+1));	


 	mat_delref(cring, &mat1);
 	mat_delref(cring, &mat2);
 	mat_delref(cring, &mat3);
	integer_delref(det1);  


	return x;
}
