/******************************************************************************
  mat_vector_col_mult.c
******************************************************************************/
#include "kant.h" 
#include "vector.h"

vector
mat_vector_col_mult WITH_3_ARGS(
	t_handle,		cring,
	matrix,		mat,
	vector,		v
)
/******************************************************************************
 
Description:	Multiplies a matrix and a vector.

Calling sequence:
 
	r = mat_vector_col_mult(cring,mat,v)

	vector		r		= t_handle of the result
	ring		cring		= t_handle of the mat-entries ring
	matrix		mat		= t_handle of matrix
	vector		v		= t_handle of vector
 
History:
 
	92-01-13 KW    written
 
******************************************************************************/
{
	block_declarations;

	vector		tempa,tempb;

	tempa = mat_ring_trans(cring,v);
	tempb = mat_ring_mult(cring,mat,tempa);

	vec_delete(cring,&tempa);
	tempa = mat_ring_trans(cring,tempb);
	vec_delete(cring,&tempb);

	return(tempa);
}	
