/*******************************************************************************
  order_bach_bound.c 
********************************************************************************/
                                                             
#include <stdio.h>
#include <math.h>
#include "kant.h" 
#include "conv.e"
#include "anf.h" 

integer_big
order_bach_bound WITH_1_ARG (
	order,   ord  
)
/*******************************************************************************

Description:
   
	Computes the Bach bound for a given number field.
	The given order should be the maximal order.

	A theorem of Bach asserts (under the assumption of GRH) that all prime ideals
	with norm below this bound generate the class group.
 
        If D is the absolute value of the field discriminant the bound is given
        via
 
                 6  * (log D)^2     if the field is imaginary quadratic
                 12 * (log D)^2     else
 

Calling sequence:
                                                           
           bach  = calc_bach_bound (ord);                       
           order 	ord:  The order has to be the ring of integers of 
                              a number field. 

          integer_big 	bach: The Bach bound

                                                             
                            
History:                                 
                    
	JS 	04.06.92	first version

********************************************************************************/
{
	block_declarations;         
 
        t_handle             R;
        t_real             fac, dreal, ln, lnsq, breal;
        integer_big        d, bach;
                        
	order_disc_assure(ord);  
 
	R   = real_str_create(20);
 
        if (!order_r1(ord) && order_r2(ord) == 1)
                fac = conv_int_to_real(R, 6);
        else
                fac = conv_int_to_real(R, 12);
 
        d   	= integer_abs(order_disc(ord));
        dreal   = conv_int_to_real(R, d);
        ln      = real_log(R, dreal);
        lnsq    = real_mult(R, ln, ln);
        breal   = real_mult(R, fac, lnsq);

	bach    = conv_real_to_int_ceil(R, breal);
 
	real_delete(&fac);
	real_delete(&dreal);
	real_delete(&ln);
	real_delete(&lnsq);
	real_delete(&breal);
	ring_delete(&R);
 
        integer_delref(d);
 
	if (anf_print_level > 0) cay_print("Bach bound: %d\n", bach);
 
	return bach;
}

