/******************************************************************************
  order_fac_basis_ideal.c                                                           
******************************************************************************/
 
#include "kant.h"
 
anf_ideal
order_fac_basis_ideal WITH_2_ARGS(
	order,		ord,
        integer_small,  num

)
/*******************************************************************************

Description: 
                                       
        Gives prime ideal # num from the actual factor basis of ord.
        This function is not written with the objective of speed and 
        should not be used in loops running over all ideals in the
        factor basis.

Calling sequence: 
	
	id = order_fac_basis_ideal(ord);
                               
	order		ord    = t_handle of the order 
	integer_small	num    = number of ideal
 
History:

 	92-09-01 JS 	first version
  
*******************************************************************************/
{
	block_declarations;
        
        integer_small   i,  nump, numid;
        t_handle          ideals;
                                       
        nump = order_fac_basis_len(ord);

	for (i=1; i<=nump; i++)  
	{                      
                ideals = order_fac_basis_ideals(ord, i);
                numid  = m_poly_z_faclst_len(ideals);
                num   -= numid;
                if (num <= 0)   
                {              
                        return anf_ideal_incref
			(m_poly_z_faclst_factor(ideals, numid+num-1));
                }
        }
        anf_error("Wrong number submitted to order_fac_basis_ideal.");
}

